# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.sticker import Sticker
from typing import Optional, Set
from typing_extensions import Self

class Gift(BaseModel):
    """
    This object represents a gift that can be sent by the bot.
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the gift")
    sticker: Sticker
    star_count: StrictInt = Field(description="The number of Telegram Stars that must be paid to send the sticker")
    upgrade_star_count: Optional[StrictInt] = Field(default=None, description="*Optional*. The number of Telegram Stars that must be paid to upgrade the gift to a unique one")
    total_count: Optional[StrictInt] = Field(default=None, description="*Optional*. The total number of the gifts of this type that can be sent; for limited gifts only")
    remaining_count: Optional[StrictInt] = Field(default=None, description="*Optional*. The number of remaining gifts of this type that can be sent; for limited gifts only")
    __properties: ClassVar[List[str]] = ["id", "sticker", "star_count", "upgrade_star_count", "total_count", "remaining_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Gift from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sticker
        if self.sticker:
            _dict['sticker'] = self.sticker.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Gift from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "sticker": Sticker.from_dict(obj["sticker"]) if obj.get("sticker") is not None else None,
            "star_count": obj.get("star_count"),
            "upgrade_star_count": obj.get("upgrade_star_count"),
            "total_count": obj.get("total_count"),
            "remaining_count": obj.get("remaining_count")
        })
        return _obj


