# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GiveawayCompleted(BaseModel):
    """
    This object represents a service message about the completion of a giveaway without public winners.
    """ # noqa: E501
    winner_count: StrictInt = Field(description="Number of winners in the giveaway")
    unclaimed_prize_count: Optional[StrictInt] = Field(default=None, description="*Optional*. Number of undistributed prizes")
    giveaway_message: Optional[Message] = None
    is_star_giveaway: Optional[StrictBool] = Field(default=True, description="*Optional*. *True*, if the giveaway is a Telegram Star giveaway. Otherwise, currently, the giveaway is a Telegram Premium giveaway.")
    __properties: ClassVar[List[str]] = ["winner_count", "unclaimed_prize_count", "giveaway_message", "is_star_giveaway"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GiveawayCompleted from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of giveaway_message
        if self.giveaway_message:
            _dict['giveaway_message'] = self.giveaway_message.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GiveawayCompleted from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "winner_count": obj.get("winner_count"),
            "unclaimed_prize_count": obj.get("unclaimed_prize_count"),
            "giveaway_message": Message.from_dict(obj["giveaway_message"]) if obj.get("giveaway_message") is not None else None,
            "is_star_giveaway": obj.get("is_star_giveaway") if obj.get("is_star_giveaway") is not None else True
        })
        return _obj

from tele_api_python.models.message import Message
# TODO: Rewrite to not use raise_errors
GiveawayCompleted.model_rebuild(raise_errors=False)

