# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.mask_position import MaskPosition
from typing import Optional, Set
from typing_extensions import Self

class InputSticker(BaseModel):
    """
    This object describes a sticker to be added to a sticker set.
    """ # noqa: E501
    sticker: Optional[StrictStr]
    format: StrictStr = Field(description="Format of the added sticker, must be one of “static” for a **.WEBP** or **.PNG** image, “animated” for a **.TGS** animation, “video” for a **.WEBM** video")
    emoji_list: List[StrictStr] = Field(description="List of 1-20 emoji associated with the sticker")
    mask_position: Optional[MaskPosition] = None
    keywords: Optional[List[StrictStr]] = Field(default=None, description="*Optional*. List of 0-20 search keywords for the sticker with total length of up to 64 characters. For “regular” and “custom\\_emoji” stickers only.")
    __properties: ClassVar[List[str]] = ["sticker", "format", "emoji_list", "mask_position", "keywords"]

    @field_validator('format')
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['static', 'animated', 'video']):
            raise ValueError("must be one of enum values ('static', 'animated', 'video')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InputSticker from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mask_position
        if self.mask_position:
            _dict['mask_position'] = self.mask_position.to_dict()
        # set to None if sticker (nullable) is None
        # and model_fields_set contains the field
        if self.sticker is None and "sticker" in self.model_fields_set:
            _dict['sticker'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InputSticker from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sticker": obj.get("sticker"),
            "format": obj.get("format"),
            "emoji_list": obj.get("emoji_list"),
            "mask_position": MaskPosition.from_dict(obj["mask_position"]) if obj.get("mask_position") is not None else None,
            "keywords": obj.get("keywords")
        })
        return _obj


