# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.keyboard_button_poll_type import KeyboardButtonPollType
from tele_api_python.models.keyboard_button_request_chat import KeyboardButtonRequestChat
from tele_api_python.models.keyboard_button_request_users import KeyboardButtonRequestUsers
from tele_api_python.models.web_app_info import WebAppInfo
from typing import Optional, Set
from typing_extensions import Self

class KeyboardButton(BaseModel):
    """
    This object represents one button of the reply keyboard. At most one of the optional fields must be used to specify type of the button. For simple text buttons, *String* can be used instead of this object to specify the button text.
    """ # noqa: E501
    text: StrictStr = Field(description="Text of the button. If none of the optional fields are used, it will be sent as a message when the button is pressed")
    request_users: Optional[KeyboardButtonRequestUsers] = None
    request_chat: Optional[KeyboardButtonRequestChat] = None
    request_contact: Optional[StrictBool] = Field(default=None, description="*Optional*. If *True*, the user's phone number will be sent as a contact when the button is pressed. Available in private chats only.")
    request_location: Optional[StrictBool] = Field(default=None, description="*Optional*. If *True*, the user's current location will be sent when the button is pressed. Available in private chats only.")
    request_poll: Optional[KeyboardButtonPollType] = None
    web_app: Optional[WebAppInfo] = None
    __properties: ClassVar[List[str]] = ["text", "request_users", "request_chat", "request_contact", "request_location", "request_poll", "web_app"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeyboardButton from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of request_users
        if self.request_users:
            _dict['request_users'] = self.request_users.to_dict()
        # override the default output from pydantic by calling `to_dict()` of request_chat
        if self.request_chat:
            _dict['request_chat'] = self.request_chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of request_poll
        if self.request_poll:
            _dict['request_poll'] = self.request_poll.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_app
        if self.web_app:
            _dict['web_app'] = self.web_app.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeyboardButton from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "text": obj.get("text"),
            "request_users": KeyboardButtonRequestUsers.from_dict(obj["request_users"]) if obj.get("request_users") is not None else None,
            "request_chat": KeyboardButtonRequestChat.from_dict(obj["request_chat"]) if obj.get("request_chat") is not None else None,
            "request_contact": obj.get("request_contact"),
            "request_location": obj.get("request_location"),
            "request_poll": KeyboardButtonPollType.from_dict(obj["request_poll"]) if obj.get("request_poll") is not None else None,
            "web_app": WebAppInfo.from_dict(obj["web_app"]) if obj.get("web_app") is not None else None
        })
        return _obj


