# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from tele_api_python.models.chat import Chat
from tele_api_python.models.reaction_count import ReactionCount
from typing import Optional, Set
from typing_extensions import Self

class MessageReactionCountUpdated(BaseModel):
    """
    This object represents reaction changes on a message with anonymous reactions.
    """ # noqa: E501
    chat: Chat
    message_id: StrictInt = Field(description="Unique message identifier inside the chat")
    var_date: StrictInt = Field(description="Date of the change in Unix time", alias="date")
    reactions: List[ReactionCount] = Field(description="List of reactions that are present on the message")
    __properties: ClassVar[List[str]] = ["chat", "message_id", "date", "reactions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessageReactionCountUpdated from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat
        if self.chat:
            _dict['chat'] = self.chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in reactions (list)
        _items = []
        if self.reactions:
            for _item_reactions in self.reactions:
                if _item_reactions:
                    _items.append(_item_reactions.to_dict())
            _dict['reactions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessageReactionCountUpdated from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat": Chat.from_dict(obj["chat"]) if obj.get("chat") is not None else None,
            "message_id": obj.get("message_id"),
            "date": obj.get("date"),
            "reactions": [ReactionCount.from_dict(_item) for _item in obj["reactions"]] if obj.get("reactions") is not None else None
        })
        return _obj


