# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.chat import Chat
from tele_api_python.models.reaction_type import ReactionType
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class MessageReactionUpdated(BaseModel):
    """
    This object represents a change of a reaction on a message performed by a user.
    """ # noqa: E501
    chat: Chat
    message_id: StrictInt = Field(description="Unique identifier of the message inside the chat")
    user: Optional[User] = None
    actor_chat: Optional[Chat] = None
    var_date: StrictInt = Field(description="Date of the change in Unix time", alias="date")
    old_reaction: List[ReactionType] = Field(description="Previous list of reaction types that were set by the user")
    new_reaction: List[ReactionType] = Field(description="New list of reaction types that have been set by the user")
    __properties: ClassVar[List[str]] = ["chat", "message_id", "user", "actor_chat", "date", "old_reaction", "new_reaction"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessageReactionUpdated from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat
        if self.chat:
            _dict['chat'] = self.chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actor_chat
        if self.actor_chat:
            _dict['actor_chat'] = self.actor_chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in old_reaction (list)
        _items = []
        if self.old_reaction:
            for _item_old_reaction in self.old_reaction:
                if _item_old_reaction:
                    _items.append(_item_old_reaction.to_dict())
            _dict['old_reaction'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in new_reaction (list)
        _items = []
        if self.new_reaction:
            for _item_new_reaction in self.new_reaction:
                if _item_new_reaction:
                    _items.append(_item_new_reaction.to_dict())
            _dict['new_reaction'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessageReactionUpdated from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat": Chat.from_dict(obj["chat"]) if obj.get("chat") is not None else None,
            "message_id": obj.get("message_id"),
            "user": User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "actor_chat": Chat.from_dict(obj["actor_chat"]) if obj.get("actor_chat") is not None else None,
            "date": obj.get("date"),
            "old_reaction": [ReactionType.from_dict(_item) for _item in obj["old_reaction"]] if obj.get("old_reaction") is not None else None,
            "new_reaction": [ReactionType.from_dict(_item) for _item in obj["new_reaction"]] if obj.get("new_reaction") is not None else None
        })
        return _obj


