# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.revenue_withdrawal_state_failed import RevenueWithdrawalStateFailed
from tele_api_python.models.revenue_withdrawal_state_pending import RevenueWithdrawalStatePending
from tele_api_python.models.revenue_withdrawal_state_succeeded import RevenueWithdrawalStateSucceeded
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

REVENUEWITHDRAWALSTATE_ANY_OF_SCHEMAS = ["RevenueWithdrawalStateFailed", "RevenueWithdrawalStatePending", "RevenueWithdrawalStateSucceeded"]

class RevenueWithdrawalState(BaseModel):
    """
    This object describes the state of a revenue withdrawal operation. Currently, it can be one of  * [RevenueWithdrawalStatePending](https://core.telegram.org/bots/api/#revenuewithdrawalstatepending) * [RevenueWithdrawalStateSucceeded](https://core.telegram.org/bots/api/#revenuewithdrawalstatesucceeded) * [RevenueWithdrawalStateFailed](https://core.telegram.org/bots/api/#revenuewithdrawalstatefailed)
    """

    # data type: RevenueWithdrawalStatePending
    anyof_schema_1_validator: Optional[RevenueWithdrawalStatePending] = None
    # data type: RevenueWithdrawalStateSucceeded
    anyof_schema_2_validator: Optional[RevenueWithdrawalStateSucceeded] = None
    # data type: RevenueWithdrawalStateFailed
    anyof_schema_3_validator: Optional[RevenueWithdrawalStateFailed] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[RevenueWithdrawalStateFailed, RevenueWithdrawalStatePending, RevenueWithdrawalStateSucceeded]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "RevenueWithdrawalStateFailed", "RevenueWithdrawalStatePending", "RevenueWithdrawalStateSucceeded" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = RevenueWithdrawalState.model_construct()
        error_messages = []
        # validate data type: RevenueWithdrawalStatePending
        if not isinstance(v, RevenueWithdrawalStatePending):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RevenueWithdrawalStatePending`")
        else:
            return v

        # validate data type: RevenueWithdrawalStateSucceeded
        if not isinstance(v, RevenueWithdrawalStateSucceeded):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RevenueWithdrawalStateSucceeded`")
        else:
            return v

        # validate data type: RevenueWithdrawalStateFailed
        if not isinstance(v, RevenueWithdrawalStateFailed):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RevenueWithdrawalStateFailed`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in RevenueWithdrawalState with anyOf schemas: RevenueWithdrawalStateFailed, RevenueWithdrawalStatePending, RevenueWithdrawalStateSucceeded. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[RevenueWithdrawalStatePending] = None
        try:
            instance.actual_instance = RevenueWithdrawalStatePending.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[RevenueWithdrawalStateSucceeded] = None
        try:
            instance.actual_instance = RevenueWithdrawalStateSucceeded.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[RevenueWithdrawalStateFailed] = None
        try:
            instance.actual_instance = RevenueWithdrawalStateFailed.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RevenueWithdrawalState with anyOf schemas: RevenueWithdrawalStateFailed, RevenueWithdrawalStatePending, RevenueWithdrawalStateSucceeded. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RevenueWithdrawalStateFailed, RevenueWithdrawalStatePending, RevenueWithdrawalStateSucceeded]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


