# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.affiliate_info import AffiliateInfo
from tele_api_python.models.gift import Gift
from tele_api_python.models.paid_media import PaidMedia
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class TransactionPartnerUser(BaseModel):
    """
    Describes a transaction with a user.
    """ # noqa: E501
    type: StrictStr = Field(description="Type of the transaction partner, always “user”")
    user: User
    affiliate: Optional[AffiliateInfo] = None
    invoice_payload: Optional[StrictStr] = Field(default=None, description="*Optional*. Bot-specified invoice payload")
    subscription_period: Optional[StrictInt] = Field(default=None, description="*Optional*. The duration of the paid subscription")
    paid_media: Optional[List[PaidMedia]] = Field(default=None, description="*Optional*. Information about the paid media bought by the user")
    paid_media_payload: Optional[StrictStr] = Field(default=None, description="*Optional*. Bot-specified paid media payload")
    gift: Optional[Gift] = None
    __properties: ClassVar[List[str]] = ["type", "user", "affiliate", "invoice_payload", "subscription_period", "paid_media", "paid_media_payload", "gift"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionPartnerUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of affiliate
        if self.affiliate:
            _dict['affiliate'] = self.affiliate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in paid_media (list)
        _items = []
        if self.paid_media:
            for _item_paid_media in self.paid_media:
                if _item_paid_media:
                    _items.append(_item_paid_media.to_dict())
            _dict['paid_media'] = _items
        # override the default output from pydantic by calling `to_dict()` of gift
        if self.gift:
            _dict['gift'] = self.gift.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionPartnerUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'user',
            "user": User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "affiliate": AffiliateInfo.from_dict(obj["affiliate"]) if obj.get("affiliate") is not None else None,
            "invoice_payload": obj.get("invoice_payload"),
            "subscription_period": obj.get("subscription_period"),
            "paid_media": [PaidMedia.from_dict(_item) for _item in obj["paid_media"]] if obj.get("paid_media") is not None else None,
            "paid_media_payload": obj.get("paid_media_payload"),
            "gift": Gift.from_dict(obj["gift"]) if obj.get("gift") is not None else None
        })
        return _obj


