# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WebhookInfo(BaseModel):
    """
    Describes the current status of a webhook.
    """ # noqa: E501
    url: StrictStr = Field(description="Webhook URL, may be empty if webhook is not set up")
    has_custom_certificate: StrictBool = Field(description="*True*, if a custom certificate was provided for webhook certificate checks")
    pending_update_count: StrictInt = Field(description="Number of updates awaiting delivery")
    ip_address: Optional[StrictStr] = Field(default=None, description="*Optional*. Currently used webhook IP address")
    last_error_date: Optional[StrictInt] = Field(default=None, description="*Optional*. Unix time for the most recent error that happened when trying to deliver an update via webhook")
    last_error_message: Optional[StrictStr] = Field(default=None, description="*Optional*. Error message in human-readable format for the most recent error that happened when trying to deliver an update via webhook")
    last_synchronization_error_date: Optional[StrictInt] = Field(default=None, description="*Optional*. Unix time of the most recent error that happened when trying to synchronize available updates with Telegram datacenters")
    max_connections: Optional[StrictInt] = Field(default=None, description="*Optional*. The maximum allowed number of simultaneous HTTPS connections to the webhook for update delivery")
    allowed_updates: Optional[List[StrictStr]] = Field(default=None, description="*Optional*. A list of update types the bot is subscribed to. Defaults to all update types except *chat\\_member*")
    __properties: ClassVar[List[str]] = ["url", "has_custom_certificate", "pending_update_count", "ip_address", "last_error_date", "last_error_message", "last_synchronization_error_date", "max_connections", "allowed_updates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "has_custom_certificate": obj.get("has_custom_certificate"),
            "pending_update_count": obj.get("pending_update_count"),
            "ip_address": obj.get("ip_address"),
            "last_error_date": obj.get("last_error_date"),
            "last_error_message": obj.get("last_error_message"),
            "last_synchronization_error_date": obj.get("last_synchronization_error_date"),
            "max_connections": obj.get("max_connections"),
            "allowed_updates": obj.get("allowed_updates")
        })
        return _obj


