# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.chat import Chat
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class AffiliateInfo(BaseModel):
    """
    Contains information about the affiliate that received a commission via this transaction.
    """ # noqa: E501
    affiliate_user: Optional[User] = None
    affiliate_chat: Optional[Chat] = None
    commission_per_mille: StrictInt = Field(description="The number of Telegram Stars received by the affiliate for each 1000 Telegram Stars received by the bot from referred users")
    amount: StrictInt = Field(description="Integer amount of Telegram Stars received by the affiliate from the transaction, rounded to 0; can be negative for refunds")
    nanostar_amount: Optional[StrictInt] = Field(default=None, description="*Optional*. The number of 1/1000000000 shares of Telegram Stars received by the affiliate; from -999999999 to 999999999; can be negative for refunds")
    __properties: ClassVar[List[str]] = ["affiliate_user", "affiliate_chat", "commission_per_mille", "amount", "nanostar_amount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AffiliateInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of affiliate_user
        if self.affiliate_user:
            _dict['affiliate_user'] = self.affiliate_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of affiliate_chat
        if self.affiliate_chat:
            _dict['affiliate_chat'] = self.affiliate_chat.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AffiliateInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affiliate_user": User.from_dict(obj["affiliate_user"]) if obj.get("affiliate_user") is not None else None,
            "affiliate_chat": Chat.from_dict(obj["affiliate_chat"]) if obj.get("affiliate_chat") is not None else None,
            "commission_per_mille": obj.get("commission_per_mille"),
            "amount": obj.get("amount"),
            "nanostar_amount": obj.get("nanostar_amount")
        })
        return _obj


