# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AnswerCallbackQueryPostRequest(BaseModel):
    """
    AnswerCallbackQueryPostRequest
    """ # noqa: E501
    callback_query_id: StrictStr = Field(description="Unique identifier for the query to be answered")
    text: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=200)]] = Field(default=None, description="Text of the notification. If not specified, nothing will be shown to the user, 0-200 characters")
    show_alert: Optional[StrictBool] = Field(default=False, description="If *True*, an alert will be shown by the client instead of a notification at the top of the chat screen. Defaults to *false*.")
    url: Optional[StrictStr] = Field(default=None, description="URL that will be opened by the user's client. If you have created a [Game](https://core.telegram.org/bots/api/#game) and accepted the conditions via [@BotFather](https://t.me/botfather), specify the URL that opens your game - note that this will only work if the query comes from a [*callback\\_game*](https://core.telegram.org/bots/api/#inlinekeyboardbutton) button.    Otherwise, you may use links like `t.me/your_bot?start=XXXX` that open your bot with a parameter.")
    cache_time: Optional[StrictInt] = Field(default=0, description="The maximum amount of time in seconds that the result of the callback query may be cached client-side. Telegram apps will support caching starting in version 3.14. Defaults to 0.")
    __properties: ClassVar[List[str]] = ["callback_query_id", "text", "show_alert", "url", "cache_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnswerCallbackQueryPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnswerCallbackQueryPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callback_query_id": obj.get("callback_query_id"),
            "text": obj.get("text"),
            "show_alert": obj.get("show_alert") if obj.get("show_alert") is not None else False,
            "url": obj.get("url"),
            "cache_time": obj.get("cache_time") if obj.get("cache_time") is not None else 0
        })
        return _obj


