# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.background_type_chat_theme import BackgroundTypeChatTheme
from tele_api_python.models.background_type_fill import BackgroundTypeFill
from tele_api_python.models.background_type_pattern import BackgroundTypePattern
from tele_api_python.models.background_type_wallpaper import BackgroundTypeWallpaper
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

BACKGROUNDTYPE_ANY_OF_SCHEMAS = ["BackgroundTypeChatTheme", "BackgroundTypeFill", "BackgroundTypePattern", "BackgroundTypeWallpaper"]

class BackgroundType(BaseModel):
    """
    This object describes the type of a background. Currently, it can be one of  * [BackgroundTypeFill](https://core.telegram.org/bots/api/#backgroundtypefill) * [BackgroundTypeWallpaper](https://core.telegram.org/bots/api/#backgroundtypewallpaper) * [BackgroundTypePattern](https://core.telegram.org/bots/api/#backgroundtypepattern) * [BackgroundTypeChatTheme](https://core.telegram.org/bots/api/#backgroundtypechattheme)
    """

    # data type: BackgroundTypeFill
    anyof_schema_1_validator: Optional[BackgroundTypeFill] = None
    # data type: BackgroundTypeWallpaper
    anyof_schema_2_validator: Optional[BackgroundTypeWallpaper] = None
    # data type: BackgroundTypePattern
    anyof_schema_3_validator: Optional[BackgroundTypePattern] = None
    # data type: BackgroundTypeChatTheme
    anyof_schema_4_validator: Optional[BackgroundTypeChatTheme] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[BackgroundTypeChatTheme, BackgroundTypeFill, BackgroundTypePattern, BackgroundTypeWallpaper]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "BackgroundTypeChatTheme", "BackgroundTypeFill", "BackgroundTypePattern", "BackgroundTypeWallpaper" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = BackgroundType.model_construct()
        error_messages = []
        # validate data type: BackgroundTypeFill
        if not isinstance(v, BackgroundTypeFill):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BackgroundTypeFill`")
        else:
            return v

        # validate data type: BackgroundTypeWallpaper
        if not isinstance(v, BackgroundTypeWallpaper):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BackgroundTypeWallpaper`")
        else:
            return v

        # validate data type: BackgroundTypePattern
        if not isinstance(v, BackgroundTypePattern):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BackgroundTypePattern`")
        else:
            return v

        # validate data type: BackgroundTypeChatTheme
        if not isinstance(v, BackgroundTypeChatTheme):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BackgroundTypeChatTheme`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in BackgroundType with anyOf schemas: BackgroundTypeChatTheme, BackgroundTypeFill, BackgroundTypePattern, BackgroundTypeWallpaper. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[BackgroundTypeFill] = None
        try:
            instance.actual_instance = BackgroundTypeFill.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[BackgroundTypeWallpaper] = None
        try:
            instance.actual_instance = BackgroundTypeWallpaper.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[BackgroundTypePattern] = None
        try:
            instance.actual_instance = BackgroundTypePattern.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[BackgroundTypeChatTheme] = None
        try:
            instance.actual_instance = BackgroundTypeChatTheme.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into BackgroundType with anyOf schemas: BackgroundTypeChatTheme, BackgroundTypeFill, BackgroundTypePattern, BackgroundTypeWallpaper. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], BackgroundTypeChatTheme, BackgroundTypeFill, BackgroundTypePattern, BackgroundTypeWallpaper]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


