# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.background_fill import BackgroundFill
from tele_api_python.models.document import Document
from typing import Optional, Set
from typing_extensions import Self

class BackgroundTypePattern(BaseModel):
    """
    The background is a .PNG or .TGV (gzipped subset of SVG with MIME type “application/x-tgwallpattern”) pattern to be combined with the background fill chosen by the user.
    """ # noqa: E501
    type: StrictStr = Field(description="Type of the background, always “pattern”")
    document: Document
    fill: BackgroundFill
    intensity: StrictInt = Field(description="Intensity of the pattern when it is shown above the filled background; 0-100")
    is_inverted: Optional[StrictBool] = Field(default=True, description="*Optional*. *True*, if the background fill must be applied only to the pattern itself. All other pixels are black in this case. For dark themes only")
    is_moving: Optional[StrictBool] = Field(default=True, description="*Optional*. *True*, if the background moves slightly when the device is tilted")
    __properties: ClassVar[List[str]] = ["type", "document", "fill", "intensity", "is_inverted", "is_moving"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackgroundTypePattern from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document
        if self.document:
            _dict['document'] = self.document.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fill
        if self.fill:
            _dict['fill'] = self.fill.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackgroundTypePattern from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'pattern',
            "document": Document.from_dict(obj["document"]) if obj.get("document") is not None else None,
            "fill": BackgroundFill.from_dict(obj["fill"]) if obj.get("fill") is not None else None,
            "intensity": obj.get("intensity"),
            "is_inverted": obj.get("is_inverted") if obj.get("is_inverted") is not None else True,
            "is_moving": obj.get("is_moving") if obj.get("is_moving") is not None else True
        })
        return _obj


