# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from tele_api_python.models.business_opening_hours_interval import BusinessOpeningHoursInterval
from typing import Optional, Set
from typing_extensions import Self

class BusinessOpeningHours(BaseModel):
    """
    Describes the opening hours of a business.
    """ # noqa: E501
    time_zone_name: StrictStr = Field(description="Unique name of the time zone for which the opening hours are defined")
    opening_hours: List[BusinessOpeningHoursInterval] = Field(description="List of time intervals describing business opening hours")
    __properties: ClassVar[List[str]] = ["time_zone_name", "opening_hours"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessOpeningHours from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in opening_hours (list)
        _items = []
        if self.opening_hours:
            for _item_opening_hours in self.opening_hours:
                if _item_opening_hours:
                    _items.append(_item_opening_hours.to_dict())
            _dict['opening_hours'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessOpeningHours from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "time_zone_name": obj.get("time_zone_name"),
            "opening_hours": [BusinessOpeningHoursInterval.from_dict(_item) for _item in obj["opening_hours"]] if obj.get("opening_hours") is not None else None
        })
        return _obj


