# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.maybe_inaccessible_message import MaybeInaccessibleMessage
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class CallbackQuery(BaseModel):
    """
    This object represents an incoming callback query from a callback button in an [inline keyboard](https://core.telegram.org/bots/features#inline-keyboards). If the button that originated the query was attached to a message sent by the bot, the field *message* will be present. If the button was attached to a message sent via the bot (in [inline mode](https://core.telegram.org/bots/api/#inline-mode)), the field *inline\\_message\\_id* will be present. Exactly one of the fields *data* or *game\\_short\\_name* will be present.
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for this query")
    var_from: User = Field(alias="from")
    message: Optional[MaybeInaccessibleMessage] = None
    inline_message_id: Optional[StrictStr] = Field(default=None, description="*Optional*. Identifier of the message sent via the bot in inline mode, that originated the query.")
    chat_instance: StrictStr = Field(description="Global identifier, uniquely corresponding to the chat to which the message with the callback button was sent. Useful for high scores in [games](https://core.telegram.org/bots/api/#games).")
    data: Optional[StrictStr] = Field(default=None, description="*Optional*. Data associated with the callback button. Be aware that the message originated the query can contain no callback buttons with this data.")
    game_short_name: Optional[StrictStr] = Field(default=None, description="*Optional*. Short name of a [Game](https://core.telegram.org/bots/api/#games) to be returned, serves as the unique identifier for the game")
    __properties: ClassVar[List[str]] = ["id", "from", "message", "inline_message_id", "chat_instance", "data", "game_short_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallbackQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_from
        if self.var_from:
            _dict['from'] = self.var_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallbackQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "from": User.from_dict(obj["from"]) if obj.get("from") is not None else None,
            "message": MaybeInaccessibleMessage.from_dict(obj["message"]) if obj.get("message") is not None else None,
            "inline_message_id": obj.get("inline_message_id"),
            "chat_instance": obj.get("chat_instance"),
            "data": obj.get("data"),
            "game_short_name": obj.get("game_short_name")
        })
        return _obj


