# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.chat import Chat
from tele_api_python.models.chat_invite_link import ChatInviteLink
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class ChatJoinRequest(BaseModel):
    """
    Represents a join request sent to a chat.
    """ # noqa: E501
    chat: Chat
    var_from: User = Field(alias="from")
    user_chat_id: StrictInt = Field(description="Identifier of a private chat with the user who sent the join request. This number may have more than 32 significant bits and some programming languages may have difficulty/silent defects in interpreting it. But it has at most 52 significant bits, so a 64-bit integer or double-precision float type are safe for storing this identifier. The bot can use this identifier for 5 minutes to send messages until the join request is processed, assuming no other administrator contacted the user.")
    var_date: StrictInt = Field(description="Date the request was sent in Unix time", alias="date")
    bio: Optional[StrictStr] = Field(default=None, description="*Optional*. Bio of the user.")
    invite_link: Optional[ChatInviteLink] = None
    __properties: ClassVar[List[str]] = ["chat", "from", "user_chat_id", "date", "bio", "invite_link"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatJoinRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat
        if self.chat:
            _dict['chat'] = self.chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_from
        if self.var_from:
            _dict['from'] = self.var_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invite_link
        if self.invite_link:
            _dict['invite_link'] = self.invite_link.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatJoinRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat": Chat.from_dict(obj["chat"]) if obj.get("chat") is not None else None,
            "from": User.from_dict(obj["from"]) if obj.get("from") is not None else None,
            "user_chat_id": obj.get("user_chat_id"),
            "date": obj.get("date"),
            "bio": obj.get("bio"),
            "invite_link": ChatInviteLink.from_dict(obj["invite_link"]) if obj.get("invite_link") is not None else None
        })
        return _obj


