# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.chat_member_administrator import ChatMemberAdministrator
from tele_api_python.models.chat_member_banned import ChatMemberBanned
from tele_api_python.models.chat_member_left import ChatMemberLeft
from tele_api_python.models.chat_member_member import ChatMemberMember
from tele_api_python.models.chat_member_owner import ChatMemberOwner
from tele_api_python.models.chat_member_restricted import ChatMemberRestricted
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

CHATMEMBER_ANY_OF_SCHEMAS = ["ChatMemberAdministrator", "ChatMemberBanned", "ChatMemberLeft", "ChatMemberMember", "ChatMemberOwner", "ChatMemberRestricted"]

class ChatMember(BaseModel):
    """
    This object contains information about one member of a chat. Currently, the following 6 types of chat members are supported:  * [ChatMemberOwner](https://core.telegram.org/bots/api/#chatmemberowner) * [ChatMemberAdministrator](https://core.telegram.org/bots/api/#chatmemberadministrator) * [ChatMemberMember](https://core.telegram.org/bots/api/#chatmembermember) * [ChatMemberRestricted](https://core.telegram.org/bots/api/#chatmemberrestricted) * [ChatMemberLeft](https://core.telegram.org/bots/api/#chatmemberleft) * [ChatMemberBanned](https://core.telegram.org/bots/api/#chatmemberbanned)
    """

    # data type: ChatMemberOwner
    anyof_schema_1_validator: Optional[ChatMemberOwner] = None
    # data type: ChatMemberAdministrator
    anyof_schema_2_validator: Optional[ChatMemberAdministrator] = None
    # data type: ChatMemberMember
    anyof_schema_3_validator: Optional[ChatMemberMember] = None
    # data type: ChatMemberRestricted
    anyof_schema_4_validator: Optional[ChatMemberRestricted] = None
    # data type: ChatMemberLeft
    anyof_schema_5_validator: Optional[ChatMemberLeft] = None
    # data type: ChatMemberBanned
    anyof_schema_6_validator: Optional[ChatMemberBanned] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ChatMemberAdministrator, ChatMemberBanned, ChatMemberLeft, ChatMemberMember, ChatMemberOwner, ChatMemberRestricted]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ChatMemberAdministrator", "ChatMemberBanned", "ChatMemberLeft", "ChatMemberMember", "ChatMemberOwner", "ChatMemberRestricted" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = ChatMember.model_construct()
        error_messages = []
        # validate data type: ChatMemberOwner
        if not isinstance(v, ChatMemberOwner):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatMemberOwner`")
        else:
            return v

        # validate data type: ChatMemberAdministrator
        if not isinstance(v, ChatMemberAdministrator):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatMemberAdministrator`")
        else:
            return v

        # validate data type: ChatMemberMember
        if not isinstance(v, ChatMemberMember):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatMemberMember`")
        else:
            return v

        # validate data type: ChatMemberRestricted
        if not isinstance(v, ChatMemberRestricted):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatMemberRestricted`")
        else:
            return v

        # validate data type: ChatMemberLeft
        if not isinstance(v, ChatMemberLeft):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatMemberLeft`")
        else:
            return v

        # validate data type: ChatMemberBanned
        if not isinstance(v, ChatMemberBanned):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatMemberBanned`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in ChatMember with anyOf schemas: ChatMemberAdministrator, ChatMemberBanned, ChatMemberLeft, ChatMemberMember, ChatMemberOwner, ChatMemberRestricted. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ChatMemberOwner] = None
        try:
            instance.actual_instance = ChatMemberOwner.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ChatMemberAdministrator] = None
        try:
            instance.actual_instance = ChatMemberAdministrator.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ChatMemberMember] = None
        try:
            instance.actual_instance = ChatMemberMember.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[ChatMemberRestricted] = None
        try:
            instance.actual_instance = ChatMemberRestricted.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[ChatMemberLeft] = None
        try:
            instance.actual_instance = ChatMemberLeft.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[ChatMemberBanned] = None
        try:
            instance.actual_instance = ChatMemberBanned.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ChatMember with anyOf schemas: ChatMemberAdministrator, ChatMemberBanned, ChatMemberLeft, ChatMemberMember, ChatMemberOwner, ChatMemberRestricted. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ChatMemberAdministrator, ChatMemberBanned, ChatMemberLeft, ChatMemberMember, ChatMemberOwner, ChatMemberRestricted]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


