# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from tele_api_python.models.create_chat_subscription_invite_link_post_request_chat_id import CreateChatSubscriptionInviteLinkPostRequestChatId
from typing import Optional, Set
from typing_extensions import Self

class CreateChatSubscriptionInviteLinkPostRequest(BaseModel):
    """
    CreateChatSubscriptionInviteLinkPostRequest
    """ # noqa: E501
    chat_id: CreateChatSubscriptionInviteLinkPostRequestChatId
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=32)]] = Field(default=None, description="Invite link name; 0-32 characters")
    subscription_period: StrictInt = Field(description="The number of seconds the subscription will be active for before the next payment. Currently, it must always be 2592000 (30 days).")
    subscription_price: StrictInt = Field(description="The amount of Telegram Stars a user must pay initially and after each subsequent subscription period to be a member of the chat; 1-2500")
    __properties: ClassVar[List[str]] = ["chat_id", "name", "subscription_period", "subscription_price"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateChatSubscriptionInviteLinkPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat_id
        if self.chat_id:
            _dict['chat_id'] = self.chat_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateChatSubscriptionInviteLinkPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat_id": CreateChatSubscriptionInviteLinkPostRequestChatId.from_dict(obj["chat_id"]) if obj.get("chat_id") is not None else None,
            "name": obj.get("name"),
            "subscription_period": obj.get("subscription_period"),
            "subscription_price": obj.get("subscription_price")
        })
        return _obj


