# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from tele_api_python.models.send_message_post_request_chat_id import SendMessagePostRequestChatId
from typing import Optional, Set
from typing_extensions import Self

class EditChatInviteLinkPostRequest(BaseModel):
    """
    EditChatInviteLinkPostRequest
    """ # noqa: E501
    chat_id: SendMessagePostRequestChatId
    invite_link: StrictStr = Field(description="The invite link to edit")
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=32)]] = Field(default=None, description="Invite link name; 0-32 characters")
    expire_date: Optional[StrictInt] = Field(default=None, description="Point in time (Unix timestamp) when the link will expire")
    member_limit: Optional[StrictInt] = Field(default=None, description="The maximum number of users that can be members of the chat simultaneously after joining the chat via this invite link; 1-99999")
    creates_join_request: Optional[StrictBool] = Field(default=None, description="*True*, if users joining the chat via the link need to be approved by chat administrators. If *True*, *member\\_limit* can't be specified")
    __properties: ClassVar[List[str]] = ["chat_id", "invite_link", "name", "expire_date", "member_limit", "creates_join_request"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditChatInviteLinkPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat_id
        if self.chat_id:
            _dict['chat_id'] = self.chat_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditChatInviteLinkPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat_id": SendMessagePostRequestChatId.from_dict(obj["chat_id"]) if obj.get("chat_id") is not None else None,
            "invite_link": obj.get("invite_link"),
            "name": obj.get("name"),
            "expire_date": obj.get("expire_date"),
            "member_limit": obj.get("member_limit"),
            "creates_join_request": obj.get("creates_join_request")
        })
        return _obj


