# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.forward_message_post_request_from_chat_id import ForwardMessagePostRequestFromChatId
from tele_api_python.models.send_message_post_request_chat_id import SendMessagePostRequestChatId
from typing import Optional, Set
from typing_extensions import Self

class ForwardMessagePostRequest(BaseModel):
    """
    ForwardMessagePostRequest
    """ # noqa: E501
    chat_id: SendMessagePostRequestChatId
    message_thread_id: Optional[StrictInt] = Field(default=None, description="Unique identifier for the target message thread (topic) of the forum; for forum supergroups only")
    from_chat_id: ForwardMessagePostRequestFromChatId
    video_start_timestamp: Optional[StrictInt] = Field(default=None, description="New start timestamp for the forwarded video in the message")
    disable_notification: Optional[StrictBool] = Field(default=None, description="Sends the message [silently](https://telegram.org/blog/channels-2-0#silent-messages). Users will receive a notification with no sound.")
    protect_content: Optional[StrictBool] = Field(default=None, description="Protects the contents of the forwarded message from forwarding and saving")
    message_id: StrictInt = Field(description="Message identifier in the chat specified in *from\\_chat\\_id*")
    __properties: ClassVar[List[str]] = ["chat_id", "message_thread_id", "from_chat_id", "video_start_timestamp", "disable_notification", "protect_content", "message_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ForwardMessagePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat_id
        if self.chat_id:
            _dict['chat_id'] = self.chat_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of from_chat_id
        if self.from_chat_id:
            _dict['from_chat_id'] = self.from_chat_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ForwardMessagePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat_id": SendMessagePostRequestChatId.from_dict(obj["chat_id"]) if obj.get("chat_id") is not None else None,
            "message_thread_id": obj.get("message_thread_id"),
            "from_chat_id": ForwardMessagePostRequestFromChatId.from_dict(obj["from_chat_id"]) if obj.get("from_chat_id") is not None else None,
            "video_start_timestamp": obj.get("video_start_timestamp"),
            "disable_notification": obj.get("disable_notification"),
            "protect_content": obj.get("protect_content"),
            "message_id": obj.get("message_id")
        })
        return _obj


