# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.location import Location
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class InlineQuery(BaseModel):
    """
    This object represents an incoming inline query. When the user sends an empty query, your bot could return some default or trending results.
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for this query")
    var_from: User = Field(alias="from")
    query: StrictStr = Field(description="Text of the query (up to 256 characters)")
    offset: StrictStr = Field(description="Offset of the results to be returned, can be controlled by the bot")
    chat_type: Optional[StrictStr] = Field(default=None, description="*Optional*. Type of the chat from which the inline query was sent. Can be either “sender” for a private chat with the inline query sender, “private”, “group”, “supergroup”, or “channel”. The chat type should be always known for requests sent from official clients and most third-party clients, unless the request was sent from a secret chat")
    location: Optional[Location] = None
    __properties: ClassVar[List[str]] = ["id", "from", "query", "offset", "chat_type", "location"]

    @field_validator('chat_type')
    def chat_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['sender', 'private', 'group', 'supergroup', 'channel']):
            raise ValueError("must be one of enum values ('sender', 'private', 'group', 'supergroup', 'channel')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InlineQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_from
        if self.var_from:
            _dict['from'] = self.var_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InlineQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "from": User.from_dict(obj["from"]) if obj.get("from") is not None else None,
            "query": obj.get("query"),
            "offset": obj.get("offset"),
            "chat_type": obj.get("chat_type"),
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None
        })
        return _obj


