# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.inline_query_result_article import InlineQueryResultArticle
from tele_api_python.models.inline_query_result_audio import InlineQueryResultAudio
from tele_api_python.models.inline_query_result_cached_audio import InlineQueryResultCachedAudio
from tele_api_python.models.inline_query_result_cached_document import InlineQueryResultCachedDocument
from tele_api_python.models.inline_query_result_cached_gif import InlineQueryResultCachedGif
from tele_api_python.models.inline_query_result_cached_mpeg4_gif import InlineQueryResultCachedMpeg4Gif
from tele_api_python.models.inline_query_result_cached_photo import InlineQueryResultCachedPhoto
from tele_api_python.models.inline_query_result_cached_sticker import InlineQueryResultCachedSticker
from tele_api_python.models.inline_query_result_cached_video import InlineQueryResultCachedVideo
from tele_api_python.models.inline_query_result_cached_voice import InlineQueryResultCachedVoice
from tele_api_python.models.inline_query_result_contact import InlineQueryResultContact
from tele_api_python.models.inline_query_result_document import InlineQueryResultDocument
from tele_api_python.models.inline_query_result_game import InlineQueryResultGame
from tele_api_python.models.inline_query_result_gif import InlineQueryResultGif
from tele_api_python.models.inline_query_result_location import InlineQueryResultLocation
from tele_api_python.models.inline_query_result_mpeg4_gif import InlineQueryResultMpeg4Gif
from tele_api_python.models.inline_query_result_photo import InlineQueryResultPhoto
from tele_api_python.models.inline_query_result_venue import InlineQueryResultVenue
from tele_api_python.models.inline_query_result_video import InlineQueryResultVideo
from tele_api_python.models.inline_query_result_voice import InlineQueryResultVoice
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

INLINEQUERYRESULT_ANY_OF_SCHEMAS = ["InlineQueryResultArticle", "InlineQueryResultAudio", "InlineQueryResultCachedAudio", "InlineQueryResultCachedDocument", "InlineQueryResultCachedGif", "InlineQueryResultCachedMpeg4Gif", "InlineQueryResultCachedPhoto", "InlineQueryResultCachedSticker", "InlineQueryResultCachedVideo", "InlineQueryResultCachedVoice", "InlineQueryResultContact", "InlineQueryResultDocument", "InlineQueryResultGame", "InlineQueryResultGif", "InlineQueryResultLocation", "InlineQueryResultMpeg4Gif", "InlineQueryResultPhoto", "InlineQueryResultVenue", "InlineQueryResultVideo", "InlineQueryResultVoice"]

class InlineQueryResult(BaseModel):
    """
    This object represents one result of an inline query. Telegram clients currently support results of the following 20 types:  * [InlineQueryResultCachedAudio](https://core.telegram.org/bots/api/#inlinequeryresultcachedaudio) * [InlineQueryResultCachedDocument](https://core.telegram.org/bots/api/#inlinequeryresultcacheddocument) * [InlineQueryResultCachedGif](https://core.telegram.org/bots/api/#inlinequeryresultcachedgif) * [InlineQueryResultCachedMpeg4Gif](https://core.telegram.org/bots/api/#inlinequeryresultcachedmpeg4gif) * [InlineQueryResultCachedPhoto](https://core.telegram.org/bots/api/#inlinequeryresultcachedphoto) * [InlineQueryResultCachedSticker](https://core.telegram.org/bots/api/#inlinequeryresultcachedsticker) * [InlineQueryResultCachedVideo](https://core.telegram.org/bots/api/#inlinequeryresultcachedvideo) * [InlineQueryResultCachedVoice](https://core.telegram.org/bots/api/#inlinequeryresultcachedvoice) * [InlineQueryResultArticle](https://core.telegram.org/bots/api/#inlinequeryresultarticle) * [InlineQueryResultAudio](https://core.telegram.org/bots/api/#inlinequeryresultaudio) * [InlineQueryResultContact](https://core.telegram.org/bots/api/#inlinequeryresultcontact) * [InlineQueryResultGame](https://core.telegram.org/bots/api/#inlinequeryresultgame) * [InlineQueryResultDocument](https://core.telegram.org/bots/api/#inlinequeryresultdocument) * [InlineQueryResultGif](https://core.telegram.org/bots/api/#inlinequeryresultgif) * [InlineQueryResultLocation](https://core.telegram.org/bots/api/#inlinequeryresultlocation) * [InlineQueryResultMpeg4Gif](https://core.telegram.org/bots/api/#inlinequeryresultmpeg4gif) * [InlineQueryResultPhoto](https://core.telegram.org/bots/api/#inlinequeryresultphoto) * [InlineQueryResultVenue](https://core.telegram.org/bots/api/#inlinequeryresultvenue) * [InlineQueryResultVideo](https://core.telegram.org/bots/api/#inlinequeryresultvideo) * [InlineQueryResultVoice](https://core.telegram.org/bots/api/#inlinequeryresultvoice)
    """

    # data type: InlineQueryResultCachedAudio
    anyof_schema_1_validator: Optional[InlineQueryResultCachedAudio] = None
    # data type: InlineQueryResultCachedDocument
    anyof_schema_2_validator: Optional[InlineQueryResultCachedDocument] = None
    # data type: InlineQueryResultCachedGif
    anyof_schema_3_validator: Optional[InlineQueryResultCachedGif] = None
    # data type: InlineQueryResultCachedMpeg4Gif
    anyof_schema_4_validator: Optional[InlineQueryResultCachedMpeg4Gif] = None
    # data type: InlineQueryResultCachedPhoto
    anyof_schema_5_validator: Optional[InlineQueryResultCachedPhoto] = None
    # data type: InlineQueryResultCachedSticker
    anyof_schema_6_validator: Optional[InlineQueryResultCachedSticker] = None
    # data type: InlineQueryResultCachedVideo
    anyof_schema_7_validator: Optional[InlineQueryResultCachedVideo] = None
    # data type: InlineQueryResultCachedVoice
    anyof_schema_8_validator: Optional[InlineQueryResultCachedVoice] = None
    # data type: InlineQueryResultArticle
    anyof_schema_9_validator: Optional[InlineQueryResultArticle] = None
    # data type: InlineQueryResultAudio
    anyof_schema_10_validator: Optional[InlineQueryResultAudio] = None
    # data type: InlineQueryResultContact
    anyof_schema_11_validator: Optional[InlineQueryResultContact] = None
    # data type: InlineQueryResultGame
    anyof_schema_12_validator: Optional[InlineQueryResultGame] = None
    # data type: InlineQueryResultDocument
    anyof_schema_13_validator: Optional[InlineQueryResultDocument] = None
    # data type: InlineQueryResultGif
    anyof_schema_14_validator: Optional[InlineQueryResultGif] = None
    # data type: InlineQueryResultLocation
    anyof_schema_15_validator: Optional[InlineQueryResultLocation] = None
    # data type: InlineQueryResultMpeg4Gif
    anyof_schema_16_validator: Optional[InlineQueryResultMpeg4Gif] = None
    # data type: InlineQueryResultPhoto
    anyof_schema_17_validator: Optional[InlineQueryResultPhoto] = None
    # data type: InlineQueryResultVenue
    anyof_schema_18_validator: Optional[InlineQueryResultVenue] = None
    # data type: InlineQueryResultVideo
    anyof_schema_19_validator: Optional[InlineQueryResultVideo] = None
    # data type: InlineQueryResultVoice
    anyof_schema_20_validator: Optional[InlineQueryResultVoice] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[InlineQueryResultArticle, InlineQueryResultAudio, InlineQueryResultCachedAudio, InlineQueryResultCachedDocument, InlineQueryResultCachedGif, InlineQueryResultCachedMpeg4Gif, InlineQueryResultCachedPhoto, InlineQueryResultCachedSticker, InlineQueryResultCachedVideo, InlineQueryResultCachedVoice, InlineQueryResultContact, InlineQueryResultDocument, InlineQueryResultGame, InlineQueryResultGif, InlineQueryResultLocation, InlineQueryResultMpeg4Gif, InlineQueryResultPhoto, InlineQueryResultVenue, InlineQueryResultVideo, InlineQueryResultVoice]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "InlineQueryResultArticle", "InlineQueryResultAudio", "InlineQueryResultCachedAudio", "InlineQueryResultCachedDocument", "InlineQueryResultCachedGif", "InlineQueryResultCachedMpeg4Gif", "InlineQueryResultCachedPhoto", "InlineQueryResultCachedSticker", "InlineQueryResultCachedVideo", "InlineQueryResultCachedVoice", "InlineQueryResultContact", "InlineQueryResultDocument", "InlineQueryResultGame", "InlineQueryResultGif", "InlineQueryResultLocation", "InlineQueryResultMpeg4Gif", "InlineQueryResultPhoto", "InlineQueryResultVenue", "InlineQueryResultVideo", "InlineQueryResultVoice" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = InlineQueryResult.model_construct()
        error_messages = []
        # validate data type: InlineQueryResultCachedAudio
        if not isinstance(v, InlineQueryResultCachedAudio):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedAudio`")
        else:
            return v

        # validate data type: InlineQueryResultCachedDocument
        if not isinstance(v, InlineQueryResultCachedDocument):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedDocument`")
        else:
            return v

        # validate data type: InlineQueryResultCachedGif
        if not isinstance(v, InlineQueryResultCachedGif):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedGif`")
        else:
            return v

        # validate data type: InlineQueryResultCachedMpeg4Gif
        if not isinstance(v, InlineQueryResultCachedMpeg4Gif):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedMpeg4Gif`")
        else:
            return v

        # validate data type: InlineQueryResultCachedPhoto
        if not isinstance(v, InlineQueryResultCachedPhoto):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedPhoto`")
        else:
            return v

        # validate data type: InlineQueryResultCachedSticker
        if not isinstance(v, InlineQueryResultCachedSticker):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedSticker`")
        else:
            return v

        # validate data type: InlineQueryResultCachedVideo
        if not isinstance(v, InlineQueryResultCachedVideo):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedVideo`")
        else:
            return v

        # validate data type: InlineQueryResultCachedVoice
        if not isinstance(v, InlineQueryResultCachedVoice):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultCachedVoice`")
        else:
            return v

        # validate data type: InlineQueryResultArticle
        if not isinstance(v, InlineQueryResultArticle):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultArticle`")
        else:
            return v

        # validate data type: InlineQueryResultAudio
        if not isinstance(v, InlineQueryResultAudio):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultAudio`")
        else:
            return v

        # validate data type: InlineQueryResultContact
        if not isinstance(v, InlineQueryResultContact):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultContact`")
        else:
            return v

        # validate data type: InlineQueryResultGame
        if not isinstance(v, InlineQueryResultGame):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultGame`")
        else:
            return v

        # validate data type: InlineQueryResultDocument
        if not isinstance(v, InlineQueryResultDocument):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultDocument`")
        else:
            return v

        # validate data type: InlineQueryResultGif
        if not isinstance(v, InlineQueryResultGif):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultGif`")
        else:
            return v

        # validate data type: InlineQueryResultLocation
        if not isinstance(v, InlineQueryResultLocation):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultLocation`")
        else:
            return v

        # validate data type: InlineQueryResultMpeg4Gif
        if not isinstance(v, InlineQueryResultMpeg4Gif):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultMpeg4Gif`")
        else:
            return v

        # validate data type: InlineQueryResultPhoto
        if not isinstance(v, InlineQueryResultPhoto):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultPhoto`")
        else:
            return v

        # validate data type: InlineQueryResultVenue
        if not isinstance(v, InlineQueryResultVenue):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultVenue`")
        else:
            return v

        # validate data type: InlineQueryResultVideo
        if not isinstance(v, InlineQueryResultVideo):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultVideo`")
        else:
            return v

        # validate data type: InlineQueryResultVoice
        if not isinstance(v, InlineQueryResultVoice):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InlineQueryResultVoice`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in InlineQueryResult with anyOf schemas: InlineQueryResultArticle, InlineQueryResultAudio, InlineQueryResultCachedAudio, InlineQueryResultCachedDocument, InlineQueryResultCachedGif, InlineQueryResultCachedMpeg4Gif, InlineQueryResultCachedPhoto, InlineQueryResultCachedSticker, InlineQueryResultCachedVideo, InlineQueryResultCachedVoice, InlineQueryResultContact, InlineQueryResultDocument, InlineQueryResultGame, InlineQueryResultGif, InlineQueryResultLocation, InlineQueryResultMpeg4Gif, InlineQueryResultPhoto, InlineQueryResultVenue, InlineQueryResultVideo, InlineQueryResultVoice. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[InlineQueryResultCachedAudio] = None
        try:
            instance.actual_instance = InlineQueryResultCachedAudio.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[InlineQueryResultCachedDocument] = None
        try:
            instance.actual_instance = InlineQueryResultCachedDocument.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[InlineQueryResultCachedGif] = None
        try:
            instance.actual_instance = InlineQueryResultCachedGif.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[InlineQueryResultCachedMpeg4Gif] = None
        try:
            instance.actual_instance = InlineQueryResultCachedMpeg4Gif.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[InlineQueryResultCachedPhoto] = None
        try:
            instance.actual_instance = InlineQueryResultCachedPhoto.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[InlineQueryResultCachedSticker] = None
        try:
            instance.actual_instance = InlineQueryResultCachedSticker.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_7_validator: Optional[InlineQueryResultCachedVideo] = None
        try:
            instance.actual_instance = InlineQueryResultCachedVideo.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_8_validator: Optional[InlineQueryResultCachedVoice] = None
        try:
            instance.actual_instance = InlineQueryResultCachedVoice.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_9_validator: Optional[InlineQueryResultArticle] = None
        try:
            instance.actual_instance = InlineQueryResultArticle.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_10_validator: Optional[InlineQueryResultAudio] = None
        try:
            instance.actual_instance = InlineQueryResultAudio.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_11_validator: Optional[InlineQueryResultContact] = None
        try:
            instance.actual_instance = InlineQueryResultContact.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_12_validator: Optional[InlineQueryResultGame] = None
        try:
            instance.actual_instance = InlineQueryResultGame.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_13_validator: Optional[InlineQueryResultDocument] = None
        try:
            instance.actual_instance = InlineQueryResultDocument.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_14_validator: Optional[InlineQueryResultGif] = None
        try:
            instance.actual_instance = InlineQueryResultGif.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_15_validator: Optional[InlineQueryResultLocation] = None
        try:
            instance.actual_instance = InlineQueryResultLocation.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_16_validator: Optional[InlineQueryResultMpeg4Gif] = None
        try:
            instance.actual_instance = InlineQueryResultMpeg4Gif.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_17_validator: Optional[InlineQueryResultPhoto] = None
        try:
            instance.actual_instance = InlineQueryResultPhoto.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_18_validator: Optional[InlineQueryResultVenue] = None
        try:
            instance.actual_instance = InlineQueryResultVenue.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_19_validator: Optional[InlineQueryResultVideo] = None
        try:
            instance.actual_instance = InlineQueryResultVideo.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_20_validator: Optional[InlineQueryResultVoice] = None
        try:
            instance.actual_instance = InlineQueryResultVoice.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into InlineQueryResult with anyOf schemas: InlineQueryResultArticle, InlineQueryResultAudio, InlineQueryResultCachedAudio, InlineQueryResultCachedDocument, InlineQueryResultCachedGif, InlineQueryResultCachedMpeg4Gif, InlineQueryResultCachedPhoto, InlineQueryResultCachedSticker, InlineQueryResultCachedVideo, InlineQueryResultCachedVoice, InlineQueryResultContact, InlineQueryResultDocument, InlineQueryResultGame, InlineQueryResultGif, InlineQueryResultLocation, InlineQueryResultMpeg4Gif, InlineQueryResultPhoto, InlineQueryResultVenue, InlineQueryResultVideo, InlineQueryResultVoice. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InlineQueryResultArticle, InlineQueryResultAudio, InlineQueryResultCachedAudio, InlineQueryResultCachedDocument, InlineQueryResultCachedGif, InlineQueryResultCachedMpeg4Gif, InlineQueryResultCachedPhoto, InlineQueryResultCachedSticker, InlineQueryResultCachedVideo, InlineQueryResultCachedVoice, InlineQueryResultContact, InlineQueryResultDocument, InlineQueryResultGame, InlineQueryResultGif, InlineQueryResultLocation, InlineQueryResultMpeg4Gif, InlineQueryResultPhoto, InlineQueryResultVenue, InlineQueryResultVideo, InlineQueryResultVoice]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


