# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.inline_keyboard_markup import InlineKeyboardMarkup
from tele_api_python.models.input_message_content import InputMessageContent
from typing import Optional, Set
from typing_extensions import Self

class InlineQueryResultArticle(BaseModel):
    """
    Represents a link to an article or web page.
    """ # noqa: E501
    type: StrictStr = Field(description="Type of the result, must be *article*")
    id: StrictStr = Field(description="Unique identifier for this result, 1-64 Bytes")
    title: StrictStr = Field(description="Title of the result")
    input_message_content: InputMessageContent
    reply_markup: Optional[InlineKeyboardMarkup] = None
    url: Optional[StrictStr] = Field(default=None, description="*Optional*. URL of the result")
    description: Optional[StrictStr] = Field(default=None, description="*Optional*. Short description of the result")
    thumbnail_url: Optional[StrictStr] = Field(default=None, description="*Optional*. Url of the thumbnail for the result")
    thumbnail_width: Optional[StrictInt] = Field(default=None, description="*Optional*. Thumbnail width")
    thumbnail_height: Optional[StrictInt] = Field(default=None, description="*Optional*. Thumbnail height")
    __properties: ClassVar[List[str]] = ["type", "id", "title", "input_message_content", "reply_markup", "url", "description", "thumbnail_url", "thumbnail_width", "thumbnail_height"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InlineQueryResultArticle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of input_message_content
        if self.input_message_content:
            _dict['input_message_content'] = self.input_message_content.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reply_markup
        if self.reply_markup:
            _dict['reply_markup'] = self.reply_markup.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InlineQueryResultArticle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'article',
            "id": obj.get("id"),
            "title": obj.get("title"),
            "input_message_content": InputMessageContent.from_dict(obj["input_message_content"]) if obj.get("input_message_content") is not None else None,
            "reply_markup": InlineKeyboardMarkup.from_dict(obj["reply_markup"]) if obj.get("reply_markup") is not None else None,
            "url": obj.get("url"),
            "description": obj.get("description"),
            "thumbnail_url": obj.get("thumbnail_url"),
            "thumbnail_width": obj.get("thumbnail_width"),
            "thumbnail_height": obj.get("thumbnail_height")
        })
        return _obj


