# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InputLocationMessageContent(BaseModel):
    """
    Represents the [content](https://core.telegram.org/bots/api/#inputmessagecontent) of a location message to be sent as the result of an inline query.
    """ # noqa: E501
    latitude: Union[StrictFloat, StrictInt] = Field(description="Latitude of the location in degrees")
    longitude: Union[StrictFloat, StrictInt] = Field(description="Longitude of the location in degrees")
    horizontal_accuracy: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="*Optional*. The radius of uncertainty for the location, measured in meters; 0-1500")
    live_period: Optional[StrictInt] = Field(default=None, description="*Optional*. Period in seconds during which the location can be updated, should be between 60 and 86400, or 0x7FFFFFFF for live locations that can be edited indefinitely.")
    heading: Optional[StrictInt] = Field(default=None, description="*Optional*. For live locations, a direction in which the user is moving, in degrees. Must be between 1 and 360 if specified.")
    proximity_alert_radius: Optional[StrictInt] = Field(default=None, description="*Optional*. For live locations, a maximum distance for proximity alerts about approaching another chat member, in meters. Must be between 1 and 100000 if specified.")
    __properties: ClassVar[List[str]] = ["latitude", "longitude", "horizontal_accuracy", "live_period", "heading", "proximity_alert_radius"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InputLocationMessageContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InputLocationMessageContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "horizontal_accuracy": obj.get("horizontal_accuracy"),
            "live_period": obj.get("live_period"),
            "heading": obj.get("heading"),
            "proximity_alert_radius": obj.get("proximity_alert_radius")
        })
        return _obj


