# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.input_media_animation import InputMediaAnimation
from tele_api_python.models.input_media_audio import InputMediaAudio
from tele_api_python.models.input_media_document import InputMediaDocument
from tele_api_python.models.input_media_photo import InputMediaPhoto
from tele_api_python.models.input_media_video import InputMediaVideo
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

INPUTMEDIA_ANY_OF_SCHEMAS = ["InputMediaAnimation", "InputMediaAudio", "InputMediaDocument", "InputMediaPhoto", "InputMediaVideo"]

class InputMedia(BaseModel):
    """
    This object represents the content of a media message to be sent. It should be one of  * [InputMediaAnimation](https://core.telegram.org/bots/api/#inputmediaanimation) * [InputMediaDocument](https://core.telegram.org/bots/api/#inputmediadocument) * [InputMediaAudio](https://core.telegram.org/bots/api/#inputmediaaudio) * [InputMediaPhoto](https://core.telegram.org/bots/api/#inputmediaphoto) * [InputMediaVideo](https://core.telegram.org/bots/api/#inputmediavideo)
    """

    # data type: InputMediaAnimation
    anyof_schema_1_validator: Optional[InputMediaAnimation] = None
    # data type: InputMediaDocument
    anyof_schema_2_validator: Optional[InputMediaDocument] = None
    # data type: InputMediaAudio
    anyof_schema_3_validator: Optional[InputMediaAudio] = None
    # data type: InputMediaPhoto
    anyof_schema_4_validator: Optional[InputMediaPhoto] = None
    # data type: InputMediaVideo
    anyof_schema_5_validator: Optional[InputMediaVideo] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[InputMediaAnimation, InputMediaAudio, InputMediaDocument, InputMediaPhoto, InputMediaVideo]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "InputMediaAnimation", "InputMediaAudio", "InputMediaDocument", "InputMediaPhoto", "InputMediaVideo" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = InputMedia.model_construct()
        error_messages = []
        # validate data type: InputMediaAnimation
        if not isinstance(v, InputMediaAnimation):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InputMediaAnimation`")
        else:
            return v

        # validate data type: InputMediaDocument
        if not isinstance(v, InputMediaDocument):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InputMediaDocument`")
        else:
            return v

        # validate data type: InputMediaAudio
        if not isinstance(v, InputMediaAudio):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InputMediaAudio`")
        else:
            return v

        # validate data type: InputMediaPhoto
        if not isinstance(v, InputMediaPhoto):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InputMediaPhoto`")
        else:
            return v

        # validate data type: InputMediaVideo
        if not isinstance(v, InputMediaVideo):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InputMediaVideo`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in InputMedia with anyOf schemas: InputMediaAnimation, InputMediaAudio, InputMediaDocument, InputMediaPhoto, InputMediaVideo. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[InputMediaAnimation] = None
        try:
            instance.actual_instance = InputMediaAnimation.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[InputMediaDocument] = None
        try:
            instance.actual_instance = InputMediaDocument.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[InputMediaAudio] = None
        try:
            instance.actual_instance = InputMediaAudio.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[InputMediaPhoto] = None
        try:
            instance.actual_instance = InputMediaPhoto.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[InputMediaVideo] = None
        try:
            instance.actual_instance = InputMediaVideo.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into InputMedia with anyOf schemas: InputMediaAnimation, InputMediaAudio, InputMediaDocument, InputMediaPhoto, InputMediaVideo. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InputMediaAnimation, InputMediaAudio, InputMediaDocument, InputMediaPhoto, InputMediaVideo]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


