# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InputVenueMessageContent(BaseModel):
    """
    Represents the [content](https://core.telegram.org/bots/api/#inputmessagecontent) of a venue message to be sent as the result of an inline query.
    """ # noqa: E501
    latitude: Union[StrictFloat, StrictInt] = Field(description="Latitude of the venue in degrees")
    longitude: Union[StrictFloat, StrictInt] = Field(description="Longitude of the venue in degrees")
    title: StrictStr = Field(description="Name of the venue")
    address: StrictStr = Field(description="Address of the venue")
    foursquare_id: Optional[StrictStr] = Field(default=None, description="*Optional*. Foursquare identifier of the venue, if known")
    foursquare_type: Optional[StrictStr] = Field(default=None, description="*Optional*. Foursquare type of the venue, if known. (For example, “arts\\_entertainment/default”, “arts\\_entertainment/aquarium” or “food/icecream”.)")
    google_place_id: Optional[StrictStr] = Field(default=None, description="*Optional*. Google Places identifier of the venue")
    google_place_type: Optional[StrictStr] = Field(default=None, description="*Optional*. Google Places type of the venue. (See [supported types](https://developers.google.com/places/web-service/supported_types).)")
    __properties: ClassVar[List[str]] = ["latitude", "longitude", "title", "address", "foursquare_id", "foursquare_type", "google_place_id", "google_place_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InputVenueMessageContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InputVenueMessageContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "title": obj.get("title"),
            "address": obj.get("address"),
            "foursquare_id": obj.get("foursquare_id"),
            "foursquare_type": obj.get("foursquare_type"),
            "google_place_id": obj.get("google_place_id"),
            "google_place_type": obj.get("google_place_type")
        })
        return _obj


