# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.chat_administrator_rights import ChatAdministratorRights
from typing import Optional, Set
from typing_extensions import Self

class KeyboardButtonRequestChat(BaseModel):
    """
    This object defines the criteria used to request a suitable chat. Information about the selected chat will be shared with the bot when the corresponding button is pressed. The bot will be granted requested rights in the chat if appropriate. [More about requesting chats »](https://core.telegram.org/bots/features#chat-and-user-selection).
    """ # noqa: E501
    request_id: StrictInt = Field(description="Signed 32-bit identifier of the request, which will be received back in the [ChatShared](https://core.telegram.org/bots/api/#chatshared) object. Must be unique within the message")
    chat_is_channel: StrictBool = Field(description="Pass *True* to request a channel chat, pass *False* to request a group or a supergroup chat.")
    chat_is_forum: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request a forum supergroup, pass *False* to request a non-forum chat. If not specified, no additional restrictions are applied.")
    chat_has_username: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request a supergroup or a channel with a username, pass *False* to request a chat without a username. If not specified, no additional restrictions are applied.")
    chat_is_created: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request a chat owned by the user. Otherwise, no additional restrictions are applied.")
    user_administrator_rights: Optional[ChatAdministratorRights] = None
    bot_administrator_rights: Optional[ChatAdministratorRights] = None
    bot_is_member: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request a chat with the bot as a member. Otherwise, no additional restrictions are applied.")
    request_title: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request the chat's title")
    request_username: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request the chat's username")
    request_photo: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request the chat's photo")
    __properties: ClassVar[List[str]] = ["request_id", "chat_is_channel", "chat_is_forum", "chat_has_username", "chat_is_created", "user_administrator_rights", "bot_administrator_rights", "bot_is_member", "request_title", "request_username", "request_photo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeyboardButtonRequestChat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user_administrator_rights
        if self.user_administrator_rights:
            _dict['user_administrator_rights'] = self.user_administrator_rights.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bot_administrator_rights
        if self.bot_administrator_rights:
            _dict['bot_administrator_rights'] = self.bot_administrator_rights.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeyboardButtonRequestChat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "request_id": obj.get("request_id"),
            "chat_is_channel": obj.get("chat_is_channel"),
            "chat_is_forum": obj.get("chat_is_forum"),
            "chat_has_username": obj.get("chat_has_username"),
            "chat_is_created": obj.get("chat_is_created"),
            "user_administrator_rights": ChatAdministratorRights.from_dict(obj["user_administrator_rights"]) if obj.get("user_administrator_rights") is not None else None,
            "bot_administrator_rights": ChatAdministratorRights.from_dict(obj["bot_administrator_rights"]) if obj.get("bot_administrator_rights") is not None else None,
            "bot_is_member": obj.get("bot_is_member"),
            "request_title": obj.get("request_title"),
            "request_username": obj.get("request_username"),
            "request_photo": obj.get("request_photo")
        })
        return _obj


