# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class KeyboardButtonRequestUsers(BaseModel):
    """
    This object defines the criteria used to request suitable users. Information about the selected users will be shared with the bot when the corresponding button is pressed. [More about requesting users »](https://core.telegram.org/bots/features#chat-and-user-selection)
    """ # noqa: E501
    request_id: StrictInt = Field(description="Signed 32-bit identifier of the request that will be received back in the [UsersShared](https://core.telegram.org/bots/api/#usersshared) object. Must be unique within the message")
    user_is_bot: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request bots, pass *False* to request regular users. If not specified, no additional restrictions are applied.")
    user_is_premium: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request premium users, pass *False* to request non-premium users. If not specified, no additional restrictions are applied.")
    max_quantity: Optional[StrictInt] = Field(default=1, description="*Optional*. The maximum number of users to be selected; 1-10. Defaults to 1.")
    request_name: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request the users' first and last names")
    request_username: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request the users' usernames")
    request_photo: Optional[StrictBool] = Field(default=None, description="*Optional*. Pass *True* to request the users' photos")
    __properties: ClassVar[List[str]] = ["request_id", "user_is_bot", "user_is_premium", "max_quantity", "request_name", "request_username", "request_photo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeyboardButtonRequestUsers from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeyboardButtonRequestUsers from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "request_id": obj.get("request_id"),
            "user_is_bot": obj.get("user_is_bot"),
            "user_is_premium": obj.get("user_is_premium"),
            "max_quantity": obj.get("max_quantity") if obj.get("max_quantity") is not None else 1,
            "request_name": obj.get("request_name"),
            "request_username": obj.get("request_username"),
            "request_photo": obj.get("request_photo")
        })
        return _obj


