# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.inaccessible_message import InaccessibleMessage
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

MAYBEINACCESSIBLEMESSAGE_ANY_OF_SCHEMAS = ["InaccessibleMessage", "Message"]

class MaybeInaccessibleMessage(BaseModel):
    """
    This object describes a message that can be inaccessible to the bot. It can be one of  * [Message](https://core.telegram.org/bots/api/#message) * [InaccessibleMessage](https://core.telegram.org/bots/api/#inaccessiblemessage)
    """

    # data type: Message
    anyof_schema_1_validator: Optional[Message] = None
    # data type: InaccessibleMessage
    anyof_schema_2_validator: Optional[InaccessibleMessage] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[InaccessibleMessage, Message]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "InaccessibleMessage", "Message" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = MaybeInaccessibleMessage.model_construct()
        error_messages = []
        # validate data type: Message
        if not isinstance(v, Message):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Message`")
        else:
            return v

        # validate data type: InaccessibleMessage
        if not isinstance(v, InaccessibleMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InaccessibleMessage`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in MaybeInaccessibleMessage with anyOf schemas: InaccessibleMessage, Message. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[Message] = None
        try:
            instance.actual_instance = Message.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[InaccessibleMessage] = None
        try:
            instance.actual_instance = InaccessibleMessage.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MaybeInaccessibleMessage with anyOf schemas: InaccessibleMessage, Message. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InaccessibleMessage, Message]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())

from tele_api_python.models.message import Message
# TODO: Rewrite to not use raise_errors
MaybeInaccessibleMessage.model_rebuild(raise_errors=False)

