# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.paid_media_photo import PaidMediaPhoto
from tele_api_python.models.paid_media_preview import PaidMediaPreview
from tele_api_python.models.paid_media_video import PaidMediaVideo
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

PAIDMEDIA_ANY_OF_SCHEMAS = ["PaidMediaPhoto", "PaidMediaPreview", "PaidMediaVideo"]

class PaidMedia(BaseModel):
    """
    This object describes paid media. Currently, it can be one of  * [PaidMediaPreview](https://core.telegram.org/bots/api/#paidmediapreview) * [PaidMediaPhoto](https://core.telegram.org/bots/api/#paidmediaphoto) * [PaidMediaVideo](https://core.telegram.org/bots/api/#paidmediavideo)
    """

    # data type: PaidMediaPreview
    anyof_schema_1_validator: Optional[PaidMediaPreview] = None
    # data type: PaidMediaPhoto
    anyof_schema_2_validator: Optional[PaidMediaPhoto] = None
    # data type: PaidMediaVideo
    anyof_schema_3_validator: Optional[PaidMediaVideo] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[PaidMediaPhoto, PaidMediaPreview, PaidMediaVideo]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "PaidMediaPhoto", "PaidMediaPreview", "PaidMediaVideo" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = PaidMedia.model_construct()
        error_messages = []
        # validate data type: PaidMediaPreview
        if not isinstance(v, PaidMediaPreview):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaidMediaPreview`")
        else:
            return v

        # validate data type: PaidMediaPhoto
        if not isinstance(v, PaidMediaPhoto):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaidMediaPhoto`")
        else:
            return v

        # validate data type: PaidMediaVideo
        if not isinstance(v, PaidMediaVideo):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaidMediaVideo`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in PaidMedia with anyOf schemas: PaidMediaPhoto, PaidMediaPreview, PaidMediaVideo. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[PaidMediaPreview] = None
        try:
            instance.actual_instance = PaidMediaPreview.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[PaidMediaPhoto] = None
        try:
            instance.actual_instance = PaidMediaPhoto.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[PaidMediaVideo] = None
        try:
            instance.actual_instance = PaidMediaVideo.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PaidMedia with anyOf schemas: PaidMediaPhoto, PaidMediaPreview, PaidMediaVideo. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], PaidMediaPhoto, PaidMediaPreview, PaidMediaVideo]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


