# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.passport_element_error_data_field import PassportElementErrorDataField
from tele_api_python.models.passport_element_error_file import PassportElementErrorFile
from tele_api_python.models.passport_element_error_files import PassportElementErrorFiles
from tele_api_python.models.passport_element_error_front_side import PassportElementErrorFrontSide
from tele_api_python.models.passport_element_error_reverse_side import PassportElementErrorReverseSide
from tele_api_python.models.passport_element_error_selfie import PassportElementErrorSelfie
from tele_api_python.models.passport_element_error_translation_file import PassportElementErrorTranslationFile
from tele_api_python.models.passport_element_error_translation_files import PassportElementErrorTranslationFiles
from tele_api_python.models.passport_element_error_unspecified import PassportElementErrorUnspecified
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

PASSPORTELEMENTERROR_ANY_OF_SCHEMAS = ["PassportElementErrorDataField", "PassportElementErrorFile", "PassportElementErrorFiles", "PassportElementErrorFrontSide", "PassportElementErrorReverseSide", "PassportElementErrorSelfie", "PassportElementErrorTranslationFile", "PassportElementErrorTranslationFiles", "PassportElementErrorUnspecified"]

class PassportElementError(BaseModel):
    """
    This object represents an error in the Telegram Passport element which was submitted that should be resolved by the user. It should be one of:  * [PassportElementErrorDataField](https://core.telegram.org/bots/api/#passportelementerrordatafield) * [PassportElementErrorFrontSide](https://core.telegram.org/bots/api/#passportelementerrorfrontside) * [PassportElementErrorReverseSide](https://core.telegram.org/bots/api/#passportelementerrorreverseside) * [PassportElementErrorSelfie](https://core.telegram.org/bots/api/#passportelementerrorselfie) * [PassportElementErrorFile](https://core.telegram.org/bots/api/#passportelementerrorfile) * [PassportElementErrorFiles](https://core.telegram.org/bots/api/#passportelementerrorfiles) * [PassportElementErrorTranslationFile](https://core.telegram.org/bots/api/#passportelementerrortranslationfile) * [PassportElementErrorTranslationFiles](https://core.telegram.org/bots/api/#passportelementerrortranslationfiles) * [PassportElementErrorUnspecified](https://core.telegram.org/bots/api/#passportelementerrorunspecified)
    """

    # data type: PassportElementErrorDataField
    anyof_schema_1_validator: Optional[PassportElementErrorDataField] = None
    # data type: PassportElementErrorFrontSide
    anyof_schema_2_validator: Optional[PassportElementErrorFrontSide] = None
    # data type: PassportElementErrorReverseSide
    anyof_schema_3_validator: Optional[PassportElementErrorReverseSide] = None
    # data type: PassportElementErrorSelfie
    anyof_schema_4_validator: Optional[PassportElementErrorSelfie] = None
    # data type: PassportElementErrorFile
    anyof_schema_5_validator: Optional[PassportElementErrorFile] = None
    # data type: PassportElementErrorFiles
    anyof_schema_6_validator: Optional[PassportElementErrorFiles] = None
    # data type: PassportElementErrorTranslationFile
    anyof_schema_7_validator: Optional[PassportElementErrorTranslationFile] = None
    # data type: PassportElementErrorTranslationFiles
    anyof_schema_8_validator: Optional[PassportElementErrorTranslationFiles] = None
    # data type: PassportElementErrorUnspecified
    anyof_schema_9_validator: Optional[PassportElementErrorUnspecified] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[PassportElementErrorDataField, PassportElementErrorFile, PassportElementErrorFiles, PassportElementErrorFrontSide, PassportElementErrorReverseSide, PassportElementErrorSelfie, PassportElementErrorTranslationFile, PassportElementErrorTranslationFiles, PassportElementErrorUnspecified]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "PassportElementErrorDataField", "PassportElementErrorFile", "PassportElementErrorFiles", "PassportElementErrorFrontSide", "PassportElementErrorReverseSide", "PassportElementErrorSelfie", "PassportElementErrorTranslationFile", "PassportElementErrorTranslationFiles", "PassportElementErrorUnspecified" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = PassportElementError.model_construct()
        error_messages = []
        # validate data type: PassportElementErrorDataField
        if not isinstance(v, PassportElementErrorDataField):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorDataField`")
        else:
            return v

        # validate data type: PassportElementErrorFrontSide
        if not isinstance(v, PassportElementErrorFrontSide):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorFrontSide`")
        else:
            return v

        # validate data type: PassportElementErrorReverseSide
        if not isinstance(v, PassportElementErrorReverseSide):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorReverseSide`")
        else:
            return v

        # validate data type: PassportElementErrorSelfie
        if not isinstance(v, PassportElementErrorSelfie):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorSelfie`")
        else:
            return v

        # validate data type: PassportElementErrorFile
        if not isinstance(v, PassportElementErrorFile):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorFile`")
        else:
            return v

        # validate data type: PassportElementErrorFiles
        if not isinstance(v, PassportElementErrorFiles):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorFiles`")
        else:
            return v

        # validate data type: PassportElementErrorTranslationFile
        if not isinstance(v, PassportElementErrorTranslationFile):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorTranslationFile`")
        else:
            return v

        # validate data type: PassportElementErrorTranslationFiles
        if not isinstance(v, PassportElementErrorTranslationFiles):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorTranslationFiles`")
        else:
            return v

        # validate data type: PassportElementErrorUnspecified
        if not isinstance(v, PassportElementErrorUnspecified):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PassportElementErrorUnspecified`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in PassportElementError with anyOf schemas: PassportElementErrorDataField, PassportElementErrorFile, PassportElementErrorFiles, PassportElementErrorFrontSide, PassportElementErrorReverseSide, PassportElementErrorSelfie, PassportElementErrorTranslationFile, PassportElementErrorTranslationFiles, PassportElementErrorUnspecified. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[PassportElementErrorDataField] = None
        try:
            instance.actual_instance = PassportElementErrorDataField.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[PassportElementErrorFrontSide] = None
        try:
            instance.actual_instance = PassportElementErrorFrontSide.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[PassportElementErrorReverseSide] = None
        try:
            instance.actual_instance = PassportElementErrorReverseSide.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[PassportElementErrorSelfie] = None
        try:
            instance.actual_instance = PassportElementErrorSelfie.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[PassportElementErrorFile] = None
        try:
            instance.actual_instance = PassportElementErrorFile.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[PassportElementErrorFiles] = None
        try:
            instance.actual_instance = PassportElementErrorFiles.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_7_validator: Optional[PassportElementErrorTranslationFile] = None
        try:
            instance.actual_instance = PassportElementErrorTranslationFile.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_8_validator: Optional[PassportElementErrorTranslationFiles] = None
        try:
            instance.actual_instance = PassportElementErrorTranslationFiles.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_9_validator: Optional[PassportElementErrorUnspecified] = None
        try:
            instance.actual_instance = PassportElementErrorUnspecified.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PassportElementError with anyOf schemas: PassportElementErrorDataField, PassportElementErrorFile, PassportElementErrorFiles, PassportElementErrorFrontSide, PassportElementErrorReverseSide, PassportElementErrorSelfie, PassportElementErrorTranslationFile, PassportElementErrorTranslationFiles, PassportElementErrorUnspecified. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], PassportElementErrorDataField, PassportElementErrorFile, PassportElementErrorFiles, PassportElementErrorFrontSide, PassportElementErrorReverseSide, PassportElementErrorSelfie, PassportElementErrorTranslationFile, PassportElementErrorTranslationFiles, PassportElementErrorUnspecified]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


