# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class PassportElementErrorDataField(BaseModel):
    """
    Represents an issue in one of the data fields that was provided by the user. The error is considered resolved when the field's value changes.
    """ # noqa: E501
    source: StrictStr = Field(description="Error source, must be *data*")
    type: StrictStr = Field(description="The section of the user's Telegram Passport which has the error, one of “personal\\_details”, “passport”, “driver\\_license”, “identity\\_card”, “internal\\_passport”, “address”")
    field_name: StrictStr = Field(description="Name of the data field which has the error")
    data_hash: StrictStr = Field(description="Base64-encoded data hash")
    message: StrictStr = Field(description="Error message")
    __properties: ClassVar[List[str]] = ["source", "type", "field_name", "data_hash", "message"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['personal_details', 'passport', 'driver_license', 'identity_card', 'internal_passport', 'address']):
            raise ValueError("must be one of enum values ('personal_details', 'passport', 'driver_license', 'identity_card', 'internal_passport', 'address')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PassportElementErrorDataField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PassportElementErrorDataField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source": obj.get("source") if obj.get("source") is not None else 'data',
            "type": obj.get("type"),
            "field_name": obj.get("field_name"),
            "data_hash": obj.get("data_hash"),
            "message": obj.get("message")
        })
        return _obj


