# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.order_info import OrderInfo
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class PreCheckoutQuery(BaseModel):
    """
    This object contains information about an incoming pre-checkout query.
    """ # noqa: E501
    id: StrictStr = Field(description="Unique query identifier")
    var_from: User = Field(alias="from")
    currency: StrictStr = Field(description="Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or “XTR” for payments in [Telegram Stars](https://t.me/BotNews/90)")
    total_amount: StrictInt = Field(description="Total price in the *smallest units* of the currency (integer, **not** float/double). For example, for a price of `US$ 1.45` pass `amount = 145`. See the *exp* parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).")
    invoice_payload: StrictStr = Field(description="Bot-specified invoice payload")
    shipping_option_id: Optional[StrictStr] = Field(default=None, description="*Optional*. Identifier of the shipping option chosen by the user")
    order_info: Optional[OrderInfo] = None
    __properties: ClassVar[List[str]] = ["id", "from", "currency", "total_amount", "invoice_payload", "shipping_option_id", "order_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PreCheckoutQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_from
        if self.var_from:
            _dict['from'] = self.var_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_info
        if self.order_info:
            _dict['order_info'] = self.order_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PreCheckoutQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "from": User.from_dict(obj["from"]) if obj.get("from") is not None else None,
            "currency": obj.get("currency"),
            "total_amount": obj.get("total_amount"),
            "invoice_payload": obj.get("invoice_payload"),
            "shipping_option_id": obj.get("shipping_option_id"),
            "order_info": OrderInfo.from_dict(obj["order_info"]) if obj.get("order_info") is not None else None
        })
        return _obj


