# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.reaction_type_custom_emoji import ReactionTypeCustomEmoji
from tele_api_python.models.reaction_type_emoji import ReactionTypeEmoji
from tele_api_python.models.reaction_type_paid import ReactionTypePaid
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

REACTIONTYPE_ANY_OF_SCHEMAS = ["ReactionTypeCustomEmoji", "ReactionTypeEmoji", "ReactionTypePaid"]

class ReactionType(BaseModel):
    """
    This object describes the type of a reaction. Currently, it can be one of  * [ReactionTypeEmoji](https://core.telegram.org/bots/api/#reactiontypeemoji) * [ReactionTypeCustomEmoji](https://core.telegram.org/bots/api/#reactiontypecustomemoji) * [ReactionTypePaid](https://core.telegram.org/bots/api/#reactiontypepaid)
    """

    # data type: ReactionTypeEmoji
    anyof_schema_1_validator: Optional[ReactionTypeEmoji] = None
    # data type: ReactionTypeCustomEmoji
    anyof_schema_2_validator: Optional[ReactionTypeCustomEmoji] = None
    # data type: ReactionTypePaid
    anyof_schema_3_validator: Optional[ReactionTypePaid] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ReactionTypeCustomEmoji, ReactionTypeEmoji, ReactionTypePaid]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ReactionTypeCustomEmoji", "ReactionTypeEmoji", "ReactionTypePaid" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = ReactionType.model_construct()
        error_messages = []
        # validate data type: ReactionTypeEmoji
        if not isinstance(v, ReactionTypeEmoji):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ReactionTypeEmoji`")
        else:
            return v

        # validate data type: ReactionTypeCustomEmoji
        if not isinstance(v, ReactionTypeCustomEmoji):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ReactionTypeCustomEmoji`")
        else:
            return v

        # validate data type: ReactionTypePaid
        if not isinstance(v, ReactionTypePaid):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ReactionTypePaid`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in ReactionType with anyOf schemas: ReactionTypeCustomEmoji, ReactionTypeEmoji, ReactionTypePaid. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ReactionTypeEmoji] = None
        try:
            instance.actual_instance = ReactionTypeEmoji.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ReactionTypeCustomEmoji] = None
        try:
            instance.actual_instance = ReactionTypeCustomEmoji.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ReactionTypePaid] = None
        try:
            instance.actual_instance = ReactionTypePaid.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ReactionType with anyOf schemas: ReactionTypeCustomEmoji, ReactionTypeEmoji, ReactionTypePaid. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ReactionTypeCustomEmoji, ReactionTypeEmoji, ReactionTypePaid]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


