# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from tele_api_python.models.inline_keyboard_markup import InlineKeyboardMarkup
from tele_api_python.models.labeled_price import LabeledPrice
from tele_api_python.models.reply_parameters import ReplyParameters
from tele_api_python.models.send_message_post_request_chat_id import SendMessagePostRequestChatId
from typing import Optional, Set
from typing_extensions import Self

class SendInvoicePostRequest(BaseModel):
    """
    SendInvoicePostRequest
    """ # noqa: E501
    chat_id: SendMessagePostRequestChatId
    message_thread_id: Optional[StrictInt] = Field(default=None, description="Unique identifier for the target message thread (topic) of the forum; for forum supergroups only")
    title: Annotated[str, Field(min_length=1, strict=True, max_length=32)] = Field(description="Product name, 1-32 characters")
    description: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="Product description, 1-255 characters")
    payload: StrictStr = Field(description="Bot-defined invoice payload, 1-128 bytes. This will not be displayed to the user, use it for your internal processes.")
    provider_token: Optional[StrictStr] = Field(default=None, description="Payment provider token, obtained via [@BotFather](https://t.me/botfather). Pass an empty string for payments in [Telegram Stars](https://t.me/BotNews/90).")
    currency: StrictStr = Field(description="Three-letter ISO 4217 currency code, see [more on currencies](https://core.telegram.org/bots/payments#supported-currencies). Pass “XTR” for payments in [Telegram Stars](https://t.me/BotNews/90).")
    prices: List[LabeledPrice] = Field(description="Price breakdown, a JSON-serialized list of components (e.g. product price, tax, discount, delivery cost, delivery tax, bonus, etc.). Must contain exactly one item for payments in [Telegram Stars](https://t.me/BotNews/90).")
    max_tip_amount: Optional[StrictInt] = Field(default=0, description="The maximum accepted amount for tips in the *smallest units* of the currency (integer, **not** float/double). For example, for a maximum tip of `US$ 1.45` pass `max_tip_amount = 145`. See the *exp* parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies). Defaults to 0. Not supported for payments in [Telegram Stars](https://t.me/BotNews/90).")
    suggested_tip_amounts: Optional[List[StrictInt]] = Field(default=None, description="A JSON-serialized array of suggested amounts of tips in the *smallest units* of the currency (integer, **not** float/double). At most 4 suggested tip amounts can be specified. The suggested tip amounts must be positive, passed in a strictly increased order and must not exceed *max\\_tip\\_amount*.")
    start_parameter: Optional[StrictStr] = Field(default=None, description="Unique deep-linking parameter. If left empty, **forwarded copies** of the sent message will have a *Pay* button, allowing multiple users to pay directly from the forwarded message, using the same invoice. If non-empty, forwarded copies of the sent message will have a *URL* button with a deep link to the bot (instead of a *Pay* button), with the value used as the start parameter")
    provider_data: Optional[StrictStr] = Field(default=None, description="JSON-serialized data about the invoice, which will be shared with the payment provider. A detailed description of required fields should be provided by the payment provider.")
    photo_url: Optional[StrictStr] = Field(default=None, description="URL of the product photo for the invoice. Can be a photo of the goods or a marketing image for a service. People like it better when they see what they are paying for.")
    photo_size: Optional[StrictInt] = Field(default=None, description="Photo size in bytes")
    photo_width: Optional[StrictInt] = Field(default=None, description="Photo width")
    photo_height: Optional[StrictInt] = Field(default=None, description="Photo height")
    need_name: Optional[StrictBool] = Field(default=None, description="Pass *True* if you require the user's full name to complete the order. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    need_phone_number: Optional[StrictBool] = Field(default=None, description="Pass *True* if you require the user's phone number to complete the order. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    need_email: Optional[StrictBool] = Field(default=None, description="Pass *True* if you require the user's email address to complete the order. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    need_shipping_address: Optional[StrictBool] = Field(default=None, description="Pass *True* if you require the user's shipping address to complete the order. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    send_phone_number_to_provider: Optional[StrictBool] = Field(default=None, description="Pass *True* if the user's phone number should be sent to the provider. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    send_email_to_provider: Optional[StrictBool] = Field(default=None, description="Pass *True* if the user's email address should be sent to the provider. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    is_flexible: Optional[StrictBool] = Field(default=None, description="Pass *True* if the final price depends on the shipping method. Ignored for payments in [Telegram Stars](https://t.me/BotNews/90).")
    disable_notification: Optional[StrictBool] = Field(default=None, description="Sends the message [silently](https://telegram.org/blog/channels-2-0#silent-messages). Users will receive a notification with no sound.")
    protect_content: Optional[StrictBool] = Field(default=None, description="Protects the contents of the sent message from forwarding and saving")
    allow_paid_broadcast: Optional[StrictBool] = Field(default=None, description="Pass *True* to allow up to 1000 messages per second, ignoring [broadcasting limits](https://core.telegram.org/bots/faq#how-can-i-message-all-of-my-bot-39s-subscribers-at-once) for a fee of 0.1 Telegram Stars per message. The relevant Stars will be withdrawn from the bot's balance")
    message_effect_id: Optional[StrictStr] = Field(default=None, description="Unique identifier of the message effect to be added to the message; for private chats only")
    reply_parameters: Optional[ReplyParameters] = None
    reply_markup: Optional[InlineKeyboardMarkup] = None
    __properties: ClassVar[List[str]] = ["chat_id", "message_thread_id", "title", "description", "payload", "provider_token", "currency", "prices", "max_tip_amount", "suggested_tip_amounts", "start_parameter", "provider_data", "photo_url", "photo_size", "photo_width", "photo_height", "need_name", "need_phone_number", "need_email", "need_shipping_address", "send_phone_number_to_provider", "send_email_to_provider", "is_flexible", "disable_notification", "protect_content", "allow_paid_broadcast", "message_effect_id", "reply_parameters", "reply_markup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SendInvoicePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat_id
        if self.chat_id:
            _dict['chat_id'] = self.chat_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in prices (list)
        _items = []
        if self.prices:
            for _item_prices in self.prices:
                if _item_prices:
                    _items.append(_item_prices.to_dict())
            _dict['prices'] = _items
        # override the default output from pydantic by calling `to_dict()` of reply_parameters
        if self.reply_parameters:
            _dict['reply_parameters'] = self.reply_parameters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reply_markup
        if self.reply_markup:
            _dict['reply_markup'] = self.reply_markup.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SendInvoicePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat_id": SendMessagePostRequestChatId.from_dict(obj["chat_id"]) if obj.get("chat_id") is not None else None,
            "message_thread_id": obj.get("message_thread_id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "payload": obj.get("payload"),
            "provider_token": obj.get("provider_token"),
            "currency": obj.get("currency"),
            "prices": [LabeledPrice.from_dict(_item) for _item in obj["prices"]] if obj.get("prices") is not None else None,
            "max_tip_amount": obj.get("max_tip_amount") if obj.get("max_tip_amount") is not None else 0,
            "suggested_tip_amounts": obj.get("suggested_tip_amounts"),
            "start_parameter": obj.get("start_parameter"),
            "provider_data": obj.get("provider_data"),
            "photo_url": obj.get("photo_url"),
            "photo_size": obj.get("photo_size"),
            "photo_width": obj.get("photo_width"),
            "photo_height": obj.get("photo_height"),
            "need_name": obj.get("need_name"),
            "need_phone_number": obj.get("need_phone_number"),
            "need_email": obj.get("need_email"),
            "need_shipping_address": obj.get("need_shipping_address"),
            "send_phone_number_to_provider": obj.get("send_phone_number_to_provider"),
            "send_email_to_provider": obj.get("send_email_to_provider"),
            "is_flexible": obj.get("is_flexible"),
            "disable_notification": obj.get("disable_notification"),
            "protect_content": obj.get("protect_content"),
            "allow_paid_broadcast": obj.get("allow_paid_broadcast"),
            "message_effect_id": obj.get("message_effect_id"),
            "reply_parameters": ReplyParameters.from_dict(obj["reply_parameters"]) if obj.get("reply_parameters") is not None else None,
            "reply_markup": InlineKeyboardMarkup.from_dict(obj["reply_markup"]) if obj.get("reply_markup") is not None else None
        })
        return _obj


