# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.reaction_type import ReactionType
from tele_api_python.models.send_message_post_request_chat_id import SendMessagePostRequestChatId
from typing import Optional, Set
from typing_extensions import Self

class SetMessageReactionPostRequest(BaseModel):
    """
    SetMessageReactionPostRequest
    """ # noqa: E501
    chat_id: SendMessagePostRequestChatId
    message_id: StrictInt = Field(description="Identifier of the target message. If the message belongs to a media group, the reaction is set to the first non-deleted message in the group instead.")
    reaction: Optional[List[ReactionType]] = Field(default=None, description="A JSON-serialized list of reaction types to set on the message. Currently, as non-premium users, bots can set up to one reaction per message. A custom emoji reaction can be used if it is either already present on the message or explicitly allowed by chat administrators. Paid reactions can't be used by bots.")
    is_big: Optional[StrictBool] = Field(default=None, description="Pass *True* to set the reaction with a big animation")
    __properties: ClassVar[List[str]] = ["chat_id", "message_id", "reaction", "is_big"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SetMessageReactionPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat_id
        if self.chat_id:
            _dict['chat_id'] = self.chat_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in reaction (list)
        _items = []
        if self.reaction:
            for _item_reaction in self.reaction:
                if _item_reaction:
                    _items.append(_item_reaction.to_dict())
            _dict['reaction'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SetMessageReactionPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat_id": SendMessagePostRequestChatId.from_dict(obj["chat_id"]) if obj.get("chat_id") is not None else None,
            "message_id": obj.get("message_id"),
            "reaction": [ReactionType.from_dict(_item) for _item in obj["reaction"]] if obj.get("reaction") is not None else None,
            "is_big": obj.get("is_big")
        })
        return _obj


