# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SwitchInlineQueryChosenChat(BaseModel):
    """
    This object represents an inline button that switches the current user to inline mode in a chosen chat, with an optional default inline query.
    """ # noqa: E501
    query: Optional[StrictStr] = Field(default=None, description="*Optional*. The default inline query to be inserted in the input field. If left empty, only the bot's username will be inserted")
    allow_user_chats: Optional[StrictBool] = Field(default=None, description="*Optional*. True, if private chats with users can be chosen")
    allow_bot_chats: Optional[StrictBool] = Field(default=None, description="*Optional*. True, if private chats with bots can be chosen")
    allow_group_chats: Optional[StrictBool] = Field(default=None, description="*Optional*. True, if group and supergroup chats can be chosen")
    allow_channel_chats: Optional[StrictBool] = Field(default=None, description="*Optional*. True, if channel chats can be chosen")
    __properties: ClassVar[List[str]] = ["query", "allow_user_chats", "allow_bot_chats", "allow_group_chats", "allow_channel_chats"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SwitchInlineQueryChosenChat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SwitchInlineQueryChosenChat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "query": obj.get("query"),
            "allow_user_chats": obj.get("allow_user_chats"),
            "allow_bot_chats": obj.get("allow_bot_chats"),
            "allow_group_chats": obj.get("allow_group_chats"),
            "allow_channel_chats": obj.get("allow_channel_chats")
        })
        return _obj


