# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class TransactionPartnerAffiliateProgram(BaseModel):
    """
    Describes the affiliate program that issued the affiliate commission received via this transaction.
    """ # noqa: E501
    type: StrictStr = Field(description="Type of the transaction partner, always “affiliate\\_program”")
    sponsor_user: Optional[User] = None
    commission_per_mille: StrictInt = Field(description="The number of Telegram Stars received by the bot for each 1000 Telegram Stars received by the affiliate program sponsor from referred users")
    __properties: ClassVar[List[str]] = ["type", "sponsor_user", "commission_per_mille"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionPartnerAffiliateProgram from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sponsor_user
        if self.sponsor_user:
            _dict['sponsor_user'] = self.sponsor_user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionPartnerAffiliateProgram from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'affiliate_program',
            "sponsor_user": User.from_dict(obj["sponsor_user"]) if obj.get("sponsor_user") is not None else None,
            "commission_per_mille": obj.get("commission_per_mille")
        })
        return _obj


