from typing import List, Dict, Optional, Tuple, Any

__version__: str

class Config:
    def __init__(self) -> None: ...
    def with_min_level(self, level: str) -> None: ...
    def with_console_output(self, enabled: bool) -> None: ...
    def with_file_output(self, path: str) -> None: ...
    def with_json_format(self, enabled: bool) -> None: ...
    def with_colored_output(self, enabled: bool) -> None: ...
    def with_profiling(self, enabled: bool) -> None: ...
    def with_buffering(self, enabled: bool) -> None: ...
    def with_buffer_size(self, size: int) -> None: ...

class ContextManager:
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Optional[Any], exc_value: Optional[Any], traceback: Optional[Any]) -> bool: ...

class ProfileContext:
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Optional[Any], exc_value: Optional[Any], traceback: Optional[Any]) -> bool: ...

class ComponentContext:
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Optional[Any], exc_value: Optional[Any], traceback: Optional[Any]) -> bool: ...

class ComponentTrackerWrapper:
    def get_all_components(self) -> List[Dict[str, str]]: ...
    def count(self) -> int: ...

class VisualizationConfig:
    def __init__(self) -> None: ...
    def with_chart_type(self, chart_type: str) -> None: ...
    def with_direction(self, direction: str) -> None: ...
    def set_timing(self, show_timing: bool) -> None: ...
    def set_memory(self, show_memory: bool) -> None: ...
    def set_metadata(self, show_metadata: bool) -> None: ...

class Logger:
    def __init__(self, name: str) -> None: ...
    @staticmethod
    def with_config(name: str, config: Config) -> "Logger": ...
    def get_config(self) -> Config: ...
    def set_config(self, config: Config) -> None: ...
    def name(self) -> str: ...
    def debug(self, message: str) -> None: ...
    def info(self, message: str) -> None: ...
    def warning(self, message: str) -> None: ...
    def error(self, message: str) -> None: ...
    def critical(self, message: str) -> None: ...
    def debug_with(self, message: str, data: List[Tuple[str, str]]) -> None: ...
    def info_with(self, message: str, data: List[Tuple[str, str]]) -> None: ...
    def warning_with(self, message: str, data: List[Tuple[str, str]]) -> None: ...
    def error_with(self, message: str, data: List[Tuple[str, str]]) -> None: ...
    def critical_with(self, message: str, data: List[Tuple[str, str]]) -> None: ...
    def log_with(self, level: str, message: str, data: List[Tuple[str, str]]) -> None: ...
    def add_context(self, key: str, value: str) -> None: ...
    def remove_context(self, key: str) -> None: ...
    def clear_context(self) -> None: ...
    def with_context(self, key: str, value: str) -> ContextManager: ...
    def profile(self, operation: str) -> ProfileContext: ...
    def track_component(self, name: str) -> ComponentContext: ...
    def get_component_tracker(self) -> ComponentTrackerWrapper: ...
    def generate_visualization(self, chart_type: str, output_path: Optional[str] = None) -> str: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...

def create_logger(name: str) -> Logger: ...
