"""TelemetryFlow logging helpers.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-gen.
"""

from __future__ import annotations

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Any

from . import get_client


def debug(message: str, attributes: dict[str, Any] | None = None) -> None:
    """Log a debug message.

    Args:
        message: Log message.
        attributes: Optional log attributes.
    """
    client = get_client()
    client.log_debug(message, attributes)


def info(message: str, attributes: dict[str, Any] | None = None) -> None:
    """Log an info message.

    Args:
        message: Log message.
        attributes: Optional log attributes.

    Example:
        >>> from telemetry.logs import info
        >>> info("User logged in", {"user_id": "123"})
    """
    client = get_client()
    client.log_info(message, attributes)


def warning(message: str, attributes: dict[str, Any] | None = None) -> None:
    """Log a warning message.

    Args:
        message: Log message.
        attributes: Optional log attributes.
    """
    client = get_client()
    client.log_warning(message, attributes)


def error(message: str, attributes: dict[str, Any] | None = None) -> None:
    """Log an error message.

    Args:
        message: Log message.
        attributes: Optional log attributes.

    Example:
        >>> from telemetry.logs import error
        >>> error("Database connection failed", {"db": "postgres"})
    """
    client = get_client()
    client.log_error(message, attributes)


__all__ = [
    "debug",
    "info",
    "warning",
    "error",
]
