"""Application Configuration.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

import os
from dataclasses import dataclass
from functools import lru_cache


@dataclass
class Config:
    """Application configuration."""

    # Service
    service_name: str = "${service_name}"
    service_version: str = "${service_version}"
    environment: str = "${environment}"

    # Server
    host: str = "0.0.0.0"
    port: int = ${server_port}
    debug: bool = False

    # Database
    db_driver: str = "${db_driver}"
    db_host: str = "${db_host}"
    db_port: int = ${db_port}
    db_name: str = "${db_name}"
    db_user: str = "${db_user}"
    db_password: str = ""

    # Security
    secret_key: str = "change-me-in-production"
    jwt_secret_key: str = "change-me-in-production"
    jwt_access_token_expires: int = 3600  # seconds

    # TelemetryFlow
    telemetry_enabled: bool = True
    telemetry_api_key_id: str = ""
    telemetry_api_key_secret: str = ""
    telemetry_endpoint: str = "api.telemetryflow.id:4317"

    # Features
    cors_enabled: bool = True
    rate_limit_enabled: bool = True
    swagger_enabled: bool = True

    @property
    def database_url(self) -> str:
        """Get database connection URL."""
        if self.db_driver == "sqlite":
            return f"sqlite:///{self.db_name}.db"
        return f"{self.db_driver}://{self.db_user}:{self.db_password}@{self.db_host}:{self.db_port}/{self.db_name}"

    @classmethod
    def from_env(cls) -> "Config":
        """Create config from environment variables."""
        return cls(
            service_name=os.getenv("${env_prefix}_SERVICE_NAME", "${service_name}"),
            service_version=os.getenv("${env_prefix}_SERVICE_VERSION", "${service_version}"),
            environment=os.getenv("${env_prefix}_ENVIRONMENT", "${environment}"),
            host=os.getenv("${env_prefix}_HOST", "0.0.0.0"),
            port=int(os.getenv("${env_prefix}_PORT", "${server_port}")),
            debug=os.getenv("${env_prefix}_DEBUG", "false").lower() == "true",
            db_driver=os.getenv("${env_prefix}_DB_DRIVER", "${db_driver}"),
            db_host=os.getenv("${env_prefix}_DB_HOST", "${db_host}"),
            db_port=int(os.getenv("${env_prefix}_DB_PORT", "${db_port}")),
            db_name=os.getenv("${env_prefix}_DB_NAME", "${db_name}"),
            db_user=os.getenv("${env_prefix}_DB_USER", "${db_user}"),
            db_password=os.getenv("${env_prefix}_DB_PASSWORD", ""),
            secret_key=os.getenv("${env_prefix}_SECRET_KEY", "change-me-in-production"),
            jwt_secret_key=os.getenv("${env_prefix}_JWT_SECRET_KEY", "change-me-in-production"),
            jwt_access_token_expires=int(os.getenv("${env_prefix}_JWT_EXPIRES", "3600")),
            telemetry_enabled=os.getenv("${env_prefix}_TELEMETRY_ENABLED", "true").lower() == "true",
            telemetry_api_key_id=os.getenv("TELEMETRYFLOW_API_KEY_ID", ""),
            telemetry_api_key_secret=os.getenv("TELEMETRYFLOW_API_KEY_SECRET", ""),
            telemetry_endpoint=os.getenv("TELEMETRYFLOW_ENDPOINT", "api.telemetryflow.id:4317"),
            cors_enabled=os.getenv("${env_prefix}_CORS_ENABLED", "true").lower() == "true",
            rate_limit_enabled=os.getenv("${env_prefix}_RATE_LIMIT_ENABLED", "true").lower() == "true",
            swagger_enabled=os.getenv("${env_prefix}_SWAGGER_ENABLED", "true").lower() == "true",
        )


@lru_cache
def get_config() -> Config:
    """Get cached configuration."""
    return Config.from_env()
