"""Database Configuration.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from typing import TYPE_CHECKING

from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from sqlalchemy.orm import DeclarativeBase

if TYPE_CHECKING:
    from ${module_name}.infrastructure.config import Config


class Base(DeclarativeBase):
    """Base class for SQLAlchemy models."""
    pass


db = SQLAlchemy(model_class=Base)


def init_db(app: Flask, config: "Config") -> None:
    """Initialize database.

    Args:
        app: Flask application.
        config: Application configuration.
    """
    app.config["SQLALCHEMY_DATABASE_URI"] = config.database_url
    app.config["SQLALCHEMY_TRACK_MODIFICATIONS"] = False

    db.init_app(app)

    with app.app_context():
        # Import models here to ensure they're registered
        # from ${module_name}.domain.entity import *
        db.create_all()


def get_db() -> SQLAlchemy:
    """Get database instance."""
    return db
