"""Response Utilities.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from dataclasses import dataclass
from typing import Any

from flask import jsonify


@dataclass
class APIResponse:
    """Standard API response."""

    success: bool
    data: Any = None
    message: str | None = None
    errors: list[str] | None = None

    def to_dict(self) -> dict:
        """Convert to dictionary."""
        result = {"success": self.success}
        if self.data is not None:
            result["data"] = self.data
        if self.message:
            result["message"] = self.message
        if self.errors:
            result["errors"] = self.errors
        return result

    def to_response(self, status_code: int = 200):
        """Convert to Flask response."""
        return jsonify(self.to_dict()), status_code


def success_response(data: Any = None, message: str | None = None, status_code: int = 200):
    """Create success response."""
    return APIResponse(success=True, data=data, message=message).to_response(status_code)


def error_response(message: str, errors: list[str] | None = None, status_code: int = 400):
    """Create error response."""
    return APIResponse(success=False, message=message, errors=errors).to_response(status_code)


def created_response(data: Any = None, message: str = "Created successfully"):
    """Create 201 response."""
    return success_response(data, message, 201)


def not_found_response(message: str = "Resource not found"):
    """Create 404 response."""
    return error_response(message, status_code=404)


def validation_error_response(errors: list[str]):
    """Create validation error response."""
    return error_response("Validation failed", errors, 422)
