"""Flask Application Server.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from flask import Flask

from ${module_name}.infrastructure.config import Config
from ${module_name}.infrastructure.http.routes import register_routes
from ${module_name}.infrastructure.http.middleware import setup_middleware
from ${module_name}.infrastructure.persistence.database import init_db


def create_app(config: Config | None = None) -> Flask:
    """Create and configure the Flask application.

    Args:
        config: Application configuration.

    Returns:
        Configured Flask application.
    """
    if config is None:
        from ${module_name}.infrastructure.config import get_config
        config = get_config()

    app = Flask(__name__)

    # Configure Flask
    app.config["SECRET_KEY"] = config.secret_key
    app.config["JWT_SECRET_KEY"] = config.jwt_secret_key
    app.config["JWT_ACCESS_TOKEN_EXPIRES"] = config.jwt_access_token_expires
    app.config["SQLALCHEMY_DATABASE_URI"] = config.database_url
    app.config["SQLALCHEMY_TRACK_MODIFICATIONS"] = False

    # Store config for access
    app.config["APP_CONFIG"] = config

    # Initialize database
    init_db(app, config)

    # Setup middleware
    setup_middleware(app, config)

    # Register routes
    register_routes(app)

    return app
