# =============================================================================
# ${project_name} Makefile
# =============================================================================
#
# TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
# Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.
#
# Auto-generated by telemetryflow-restapi.
#
# =============================================================================

.PHONY: help install dev test lint format run docker-build docker-up docker-down migrate

# Variables
PYTHON := python
PIP := pip
MODULE := ${module_name}

help: ## Show this help
	@grep -E '^[a-zA-Z_-]+:.*?## .*$$' $(MAKEFILE_LIST) | sort | awk 'BEGIN {FS = ":.*?## "}; {printf "\033[36m%-20s\033[0m %s\n", $$1, $$2}'

install: ## Install dependencies
	$(PIP) install -e .

dev: ## Install development dependencies
	$(PIP) install -e ".[dev]"

test: ## Run tests
	pytest tests/ -v --cov=src/$(MODULE)

lint: ## Run linting
	ruff check src/ tests/
	mypy src/

format: ## Format code
	black src/ tests/
	ruff check --fix src/ tests/

run: ## Run the application
	$(PYTHON) -m $(MODULE).main

docker-build: ## Build Docker image
	docker build -t $(MODULE):latest .

docker-up: ## Start Docker Compose
	docker compose up -d

docker-down: ## Stop Docker Compose
	docker compose down

migrate: ## Run database migrations
	alembic upgrade head

migrate-new: ## Create new migration
	@read -p "Migration message: " msg; alembic revision --autogenerate -m "$$msg"
