"""Base Handler.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from abc import ABC, abstractmethod
from typing import Generic, TypeVar

TCommand = TypeVar("TCommand")
TQuery = TypeVar("TQuery")
TResult = TypeVar("TResult")


class CommandHandler(ABC, Generic[TCommand, TResult]):
    """Abstract command handler."""

    @abstractmethod
    def handle(self, command: TCommand) -> TResult:
        """Handle command."""
        pass


class QueryHandler(ABC, Generic[TQuery, TResult]):
    """Abstract query handler."""

    @abstractmethod
    def handle(self, query: TQuery) -> TResult:
        """Handle query."""
        pass
