"""${entity_name} HTTP Handler.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from uuid import UUID

from flask import Blueprint, request
from flasgger import swag_from

from ${module_name}.application.command.${entity_name_lower}_commands import (
    Create${entity_name}Command,
    Update${entity_name}Command,
    Delete${entity_name}Command,
)
from ${module_name}.application.query.${entity_name_lower}_queries import (
    Get${entity_name}ByIdQuery,
    List${entity_name_plural}Query,
)
from ${module_name}.application.handler.${entity_name_lower}_command_handler import (
    Create${entity_name}Handler,
    Update${entity_name}Handler,
    Delete${entity_name}Handler,
)
from ${module_name}.application.handler.${entity_name_lower}_query_handler import (
    Get${entity_name}ByIdHandler,
    List${entity_name_plural}Handler,
)
from ${module_name}.infrastructure.persistence.${entity_name_lower}_repository import SQLAlchemy${entity_name}Repository
from ${module_name}.pkg.response import success_response, created_response, not_found_response, error_response

${entity_name_lower}_bp = Blueprint("${entity_name_plural}", __name__)

# Initialize repository and handlers
_repository = SQLAlchemy${entity_name}Repository()
_create_handler = Create${entity_name}Handler(_repository)
_update_handler = Update${entity_name}Handler(_repository)
_delete_handler = Delete${entity_name}Handler(_repository)
_get_handler = Get${entity_name}ByIdHandler(_repository)
_list_handler = List${entity_name_plural}Handler(_repository)


@${entity_name_lower}_bp.route("/${entity_name_plural}", methods=["GET"])
@swag_from({
    "tags": ["${entity_name}"],
    "summary": "List all ${entity_name_plural}",
    "parameters": [
        {"name": "limit", "in": "query", "type": "integer", "default": 100},
        {"name": "offset", "in": "query", "type": "integer", "default": 0},
    ],
    "responses": {
        200: {"description": "List of ${entity_name_plural}"}
    }
})
def list_${entity_name_plural}():
    """List all ${entity_name_plural}."""
    limit = request.args.get("limit", 100, type=int)
    offset = request.args.get("offset", 0, type=int)

    query = List${entity_name_plural}Query(limit=limit, offset=offset)
    entities = _list_handler.handle(query)

    return success_response([e.to_dict() for e in entities])


@${entity_name_lower}_bp.route("/${entity_name_plural}/<uuid:id>", methods=["GET"])
@swag_from({
    "tags": ["${entity_name}"],
    "summary": "Get ${entity_name_lower} by ID",
    "parameters": [
        {"name": "id", "in": "path", "type": "string", "format": "uuid", "required": True},
    ],
    "responses": {
        200: {"description": "${entity_name} found"},
        404: {"description": "${entity_name} not found"},
    }
})
def get_${entity_name_lower}(id: UUID):
    """Get ${entity_name_lower} by ID."""
    query = Get${entity_name}ByIdQuery(id=id)
    entity = _get_handler.handle(query)

    if not entity:
        return not_found_response(f"${entity_name} with id {id} not found")

    return success_response(entity.to_dict())


@${entity_name_lower}_bp.route("/${entity_name_plural}", methods=["POST"])
@swag_from({
    "tags": ["${entity_name}"],
    "summary": "Create new ${entity_name_lower}",
    "responses": {
        201: {"description": "${entity_name} created"},
        400: {"description": "Invalid request"},
    }
})
def create_${entity_name_lower}():
    """Create new ${entity_name_lower}."""
    data = request.get_json()
    if not data:
        return error_response("Request body is required")

    command = Create${entity_name}Command(**data)
    entity = _create_handler.handle(command)

    return created_response(entity.to_dict())


@${entity_name_lower}_bp.route("/${entity_name_plural}/<uuid:id>", methods=["PUT"])
@swag_from({
    "tags": ["${entity_name}"],
    "summary": "Update ${entity_name_lower}",
    "parameters": [
        {"name": "id", "in": "path", "type": "string", "format": "uuid", "required": True},
    ],
    "responses": {
        200: {"description": "${entity_name} updated"},
        404: {"description": "${entity_name} not found"},
    }
})
def update_${entity_name_lower}(id: UUID):
    """Update ${entity_name_lower}."""
    data = request.get_json()
    if not data:
        return error_response("Request body is required")

    command = Update${entity_name}Command(id=id, **data)
    entity = _update_handler.handle(command)

    if not entity:
        return not_found_response(f"${entity_name} with id {id} not found")

    return success_response(entity.to_dict())


@${entity_name_lower}_bp.route("/${entity_name_plural}/<uuid:id>", methods=["DELETE"])
@swag_from({
    "tags": ["${entity_name}"],
    "summary": "Delete ${entity_name_lower}",
    "parameters": [
        {"name": "id", "in": "path", "type": "string", "format": "uuid", "required": True},
    ],
    "responses": {
        200: {"description": "${entity_name} deleted"},
        404: {"description": "${entity_name} not found"},
    }
})
def delete_${entity_name_lower}(id: UUID):
    """Delete ${entity_name_lower}."""
    command = Delete${entity_name}Command(id=id)
    deleted = _delete_handler.handle(command)

    if not deleted:
        return not_found_response(f"${entity_name} with id {id} not found")

    return success_response(message=f"${entity_name} with id {id} deleted")
