"""${entity_name} Query Handlers.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from ${module_name}.application.query.${entity_name_lower}_queries import (
    Get${entity_name}ByIdQuery,
    List${entity_name_plural}Query,
)
from ${module_name}.application.handler.base import QueryHandler
from ${module_name}.domain.entity.${entity_name_lower} import ${entity_name}
from ${module_name}.domain.repository.${entity_name_lower}_repository import ${entity_name}Repository


class Get${entity_name}ByIdHandler(QueryHandler[Get${entity_name}ByIdQuery, ${entity_name} | None]):
    """Handler for Get${entity_name}ByIdQuery."""

    def __init__(self, repository: ${entity_name}Repository) -> None:
        self.repository = repository

    def handle(self, query: Get${entity_name}ByIdQuery) -> ${entity_name} | None:
        """Handle get ${entity_name_lower} by ID query."""
        return self.repository.find_by_id(query.id)


class List${entity_name_plural}Handler(QueryHandler[List${entity_name_plural}Query, list[${entity_name}]]):
    """Handler for List${entity_name_plural}Query."""

    def __init__(self, repository: ${entity_name}Repository) -> None:
        self.repository = repository

    def handle(self, query: List${entity_name_plural}Query) -> list[${entity_name}]:
        """Handle list ${entity_name_plural} query."""
        return self.repository.find_all(limit=query.limit, offset=query.offset)
