# =============================================================================
# ${project_name} Docker Compose
# =============================================================================
#
# TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
# Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.
#
# Auto-generated by telemetryflow-restapi.
#
# =============================================================================

services:
  app:
    build:
      context: .
      dockerfile: Dockerfile
    ports:
      - "${server_port}:${server_port}"
    environment:
      - ${env_prefix}_DB_HOST=postgres
      - ${env_prefix}_DB_PASSWORD=postgres
    env_file:
      - .env
    depends_on:
      postgres:
        condition: service_healthy
    networks:
      - ${module_name}-network

  postgres:
    image: postgres:16-alpine
    environment:
      POSTGRES_USER: ${db_user}
      POSTGRES_PASSWORD: postgres
      POSTGRES_DB: ${db_name}
    volumes:
      - postgres-data:/var/lib/postgresql/data
    healthcheck:
      test: ["CMD-SHELL", "pg_isready -U ${db_user}"]
      interval: 5s
      timeout: 5s
      retries: 5
    networks:
      - ${module_name}-network

volumes:
  postgres-data:

networks:
  ${module_name}-network:
    driver: bridge
