# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: temporal/api/workflowservice/v1/request_response.proto, temporal/api/workflowservice/v1/service.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import Dict, List, Optional

import betterproto
import grpclib

from temporal.api.command import v1 as v1command
from temporal.api.common import v1 as v1common
from temporal.api.enums import v1 as v1enums
from temporal.api.failure import v1 as v1failure
from temporal.api.filter import v1 as v1filter
from temporal.api.history import v1 as v1history
from temporal.api.namespace import v1 as v1namespace
from temporal.api.query import v1 as v1query
from temporal.api.replication import v1 as v1replication
from temporal.api.taskqueue import v1 as v1taskqueue
from temporal.api.version import v1 as v1version
from temporal.api.workflow import v1 as v1workflow


@dataclass
class RegisterNamespaceRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    owner_email: str = betterproto.string_field(3)
    workflow_execution_retention_period: timedelta = betterproto.message_field(4)
    clusters: List[v1replication.ClusterReplicationConfig] = betterproto.message_field(
        5
    )
    active_cluster_name: str = betterproto.string_field(6)
    # A key-value map for any customized purpose.
    data: Dict[str, str] = betterproto.map_field(
        7, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    security_token: str = betterproto.string_field(8)
    is_global_namespace: bool = betterproto.bool_field(9)
    # If unspecified (ARCHIVAL_STATE_UNSPECIFIED) then default server
    # configuration is used.
    history_archival_state: v1enums.ArchivalState = betterproto.enum_field(10)
    history_archival_uri: str = betterproto.string_field(11)
    # If unspecified (ARCHIVAL_STATE_UNSPECIFIED) then default server
    # configuration is used.
    visibility_archival_state: v1enums.ArchivalState = betterproto.enum_field(12)
    visibility_archival_uri: str = betterproto.string_field(13)


@dataclass
class RegisterNamespaceResponse(betterproto.Message):
    pass


@dataclass
class ListNamespacesRequest(betterproto.Message):
    page_size: int = betterproto.int32_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class ListNamespacesResponse(betterproto.Message):
    namespaces: List["DescribeNamespaceResponse"] = betterproto.message_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class DescribeNamespaceRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)


@dataclass
class DescribeNamespaceResponse(betterproto.Message):
    namespace_info: v1namespace.NamespaceInfo = betterproto.message_field(1)
    config: v1namespace.NamespaceConfig = betterproto.message_field(2)
    replication_config: v1replication.NamespaceReplicationConfig = betterproto.message_field(
        3
    )
    failover_version: int = betterproto.int64_field(4)
    is_global_namespace: bool = betterproto.bool_field(5)


@dataclass
class UpdateNamespaceRequest(betterproto.Message):
    """
    (-- api-linter: core::0134::request-mask-required=disabled     aip.dev/not-
    precedent: UpdateNamespace RPC doesn't follow Google API format. --) (--
    api-linter: core::0134::request-resource-required=disabled     aip.dev/not-
    precedent: UpdateNamespace RPC doesn't follow Google API format. --)
    """

    name: str = betterproto.string_field(1)
    update_info: v1namespace.UpdateNamespaceInfo = betterproto.message_field(2)
    config: v1namespace.NamespaceConfig = betterproto.message_field(3)
    replication_config: v1replication.NamespaceReplicationConfig = betterproto.message_field(
        4
    )
    security_token: str = betterproto.string_field(5)
    delete_bad_binary: str = betterproto.string_field(6)


@dataclass
class UpdateNamespaceResponse(betterproto.Message):
    namespace_info: v1namespace.NamespaceInfo = betterproto.message_field(1)
    config: v1namespace.NamespaceConfig = betterproto.message_field(2)
    replication_config: v1replication.NamespaceReplicationConfig = betterproto.message_field(
        3
    )
    failover_version: int = betterproto.int64_field(4)
    is_global_namespace: bool = betterproto.bool_field(5)


@dataclass
class DeprecateNamespaceRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    security_token: str = betterproto.string_field(2)


@dataclass
class DeprecateNamespaceResponse(betterproto.Message):
    pass


@dataclass
class StartWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(4)
    input: v1common.Payloads = betterproto.message_field(5)
    # Total workflow execution timeout including retries and continue as new.
    workflow_execution_timeout: timedelta = betterproto.message_field(6)
    # Timeout of a single workflow run.
    workflow_run_timeout: timedelta = betterproto.message_field(7)
    # Timeout of a single workflow task.
    workflow_task_timeout: timedelta = betterproto.message_field(8)
    identity: str = betterproto.string_field(9)
    request_id: str = betterproto.string_field(10)
    # Default: WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE.
    workflow_id_reuse_policy: v1enums.WorkflowIdReusePolicy = betterproto.enum_field(11)
    # Retries up to workflow_execution_timeout_seconds.
    retry_policy: v1common.RetryPolicy = betterproto.message_field(12)
    cron_schedule: str = betterproto.string_field(13)
    memo: v1common.Memo = betterproto.message_field(14)
    search_attributes: v1common.SearchAttributes = betterproto.message_field(15)
    header: v1common.Header = betterproto.message_field(16)


@dataclass
class StartWorkflowExecutionResponse(betterproto.Message):
    run_id: str = betterproto.string_field(1)


@dataclass
class GetWorkflowExecutionHistoryRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    execution: v1common.WorkflowExecution = betterproto.message_field(2)
    maximum_page_size: int = betterproto.int32_field(3)
    next_page_token: bytes = betterproto.bytes_field(4)
    wait_new_event: bool = betterproto.bool_field(5)
    # Default: HISTORY_EVENT_FILTER_TYPE_ALL_EVENT.
    history_event_filter_type: v1enums.HistoryEventFilterType = betterproto.enum_field(
        6
    )
    skip_archival: bool = betterproto.bool_field(7)


@dataclass
class GetWorkflowExecutionHistoryResponse(betterproto.Message):
    history: v1history.History = betterproto.message_field(1)
    raw_history: List[v1common.DataBlob] = betterproto.message_field(2)
    next_page_token: bytes = betterproto.bytes_field(3)
    archived: bool = betterproto.bool_field(4)


@dataclass
class PollWorkflowTaskQueueRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)
    binary_checksum: str = betterproto.string_field(4)


@dataclass
class PollWorkflowTaskQueueResponse(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    previous_started_event_id: int = betterproto.int64_field(4)
    started_event_id: int = betterproto.int64_field(5)
    attempt: int = betterproto.int32_field(6)
    backlog_count_hint: int = betterproto.int64_field(7)
    history: v1history.History = betterproto.message_field(8)
    next_page_token: bytes = betterproto.bytes_field(9)
    query: v1query.WorkflowQuery = betterproto.message_field(10)
    workflow_execution_task_queue: v1taskqueue.TaskQueue = betterproto.message_field(11)
    scheduled_time: datetime = betterproto.message_field(12)
    started_time: datetime = betterproto.message_field(13)
    queries: Dict[str, v1query.WorkflowQuery] = betterproto.map_field(
        14, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass
class RespondWorkflowTaskCompletedRequest(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    commands: List[v1command.Command] = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)
    sticky_attributes: v1taskqueue.StickyExecutionAttributes = betterproto.message_field(
        4
    )
    return_new_workflow_task: bool = betterproto.bool_field(5)
    force_create_new_workflow_task: bool = betterproto.bool_field(6)
    binary_checksum: str = betterproto.string_field(7)
    query_results: Dict[str, v1query.WorkflowQueryResult] = betterproto.map_field(
        8, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass
class RespondWorkflowTaskCompletedResponse(betterproto.Message):
    workflow_task: "PollWorkflowTaskQueueResponse" = betterproto.message_field(1)


@dataclass
class RespondWorkflowTaskFailedRequest(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    cause: v1enums.WorkflowTaskFailedCause = betterproto.enum_field(2)
    failure: v1failure.Failure = betterproto.message_field(3)
    identity: str = betterproto.string_field(4)
    binary_checksum: str = betterproto.string_field(5)


@dataclass
class RespondWorkflowTaskFailedResponse(betterproto.Message):
    pass


@dataclass
class PollActivityTaskQueueRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)
    task_queue_metadata: v1taskqueue.TaskQueueMetadata = betterproto.message_field(4)


@dataclass
class PollActivityTaskQueueResponse(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    workflow_namespace: str = betterproto.string_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(4)
    activity_type: v1common.ActivityType = betterproto.message_field(5)
    activity_id: str = betterproto.string_field(6)
    header: v1common.Header = betterproto.message_field(7)
    input: v1common.Payloads = betterproto.message_field(8)
    heartbeat_details: v1common.Payloads = betterproto.message_field(9)
    scheduled_time: datetime = betterproto.message_field(10)
    current_attempt_scheduled_time: datetime = betterproto.message_field(11)
    started_time: datetime = betterproto.message_field(12)
    attempt: int = betterproto.int32_field(13)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --)
    schedule_to_close_timeout: timedelta = betterproto.message_field(14)
    # (-- api-linter: core::0140::prepositions=disabled     aip.dev/not-
    # precedent: "to" is used to indicate interval. --)
    start_to_close_timeout: timedelta = betterproto.message_field(15)
    heartbeat_timeout: timedelta = betterproto.message_field(16)
    # This is an actual retry policy the service uses. It can be different from
    # the one provided (or not) during activity scheduling as the service can
    # override the provided one in case its values are not specified or exceed
    # configured system limits.
    retry_policy: v1common.RetryPolicy = betterproto.message_field(17)


@dataclass
class RecordActivityTaskHeartbeatRequest(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    details: v1common.Payloads = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)


@dataclass
class RecordActivityTaskHeartbeatResponse(betterproto.Message):
    cancel_requested: bool = betterproto.bool_field(1)


@dataclass
class RecordActivityTaskHeartbeatByIdRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    run_id: str = betterproto.string_field(3)
    activity_id: str = betterproto.string_field(4)
    details: v1common.Payloads = betterproto.message_field(5)
    identity: str = betterproto.string_field(6)


@dataclass
class RecordActivityTaskHeartbeatByIdResponse(betterproto.Message):
    cancel_requested: bool = betterproto.bool_field(1)


@dataclass
class RespondActivityTaskCompletedRequest(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    result: v1common.Payloads = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)


@dataclass
class RespondActivityTaskCompletedResponse(betterproto.Message):
    pass


@dataclass
class RespondActivityTaskCompletedByIdRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    run_id: str = betterproto.string_field(3)
    activity_id: str = betterproto.string_field(4)
    result: v1common.Payloads = betterproto.message_field(5)
    identity: str = betterproto.string_field(6)


@dataclass
class RespondActivityTaskCompletedByIdResponse(betterproto.Message):
    pass


@dataclass
class RespondActivityTaskFailedRequest(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    failure: v1failure.Failure = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)


@dataclass
class RespondActivityTaskFailedResponse(betterproto.Message):
    pass


@dataclass
class RespondActivityTaskFailedByIdRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    run_id: str = betterproto.string_field(3)
    activity_id: str = betterproto.string_field(4)
    failure: v1failure.Failure = betterproto.message_field(5)
    identity: str = betterproto.string_field(6)


@dataclass
class RespondActivityTaskFailedByIdResponse(betterproto.Message):
    pass


@dataclass
class RespondActivityTaskCanceledRequest(betterproto.Message):
    task_token: bytes = betterproto.bytes_field(1)
    details: v1common.Payloads = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)


@dataclass
class RespondActivityTaskCanceledResponse(betterproto.Message):
    pass


@dataclass
class RespondActivityTaskCanceledByIdRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    run_id: str = betterproto.string_field(3)
    activity_id: str = betterproto.string_field(4)
    details: v1common.Payloads = betterproto.message_field(5)
    identity: str = betterproto.string_field(6)


@dataclass
class RespondActivityTaskCanceledByIdResponse(betterproto.Message):
    pass


@dataclass
class RequestCancelWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    identity: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)


@dataclass
class RequestCancelWorkflowExecutionResponse(betterproto.Message):
    pass


@dataclass
class SignalWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    signal_name: str = betterproto.string_field(3)
    input: v1common.Payloads = betterproto.message_field(4)
    identity: str = betterproto.string_field(5)
    request_id: str = betterproto.string_field(6)
    control: str = betterproto.string_field(7)


@dataclass
class SignalWorkflowExecutionResponse(betterproto.Message):
    pass


@dataclass
class SignalWithStartWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_id: str = betterproto.string_field(2)
    workflow_type: v1common.WorkflowType = betterproto.message_field(3)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(4)
    input: v1common.Payloads = betterproto.message_field(5)
    # Total workflow execution timeout including retries and continue as new
    workflow_execution_timeout: timedelta = betterproto.message_field(6)
    # Timeout of a single workflow run
    workflow_run_timeout: timedelta = betterproto.message_field(7)
    # Timeout of a single workflow task
    workflow_task_timeout: timedelta = betterproto.message_field(8)
    identity: str = betterproto.string_field(9)
    request_id: str = betterproto.string_field(10)
    workflow_id_reuse_policy: v1enums.WorkflowIdReusePolicy = betterproto.enum_field(11)
    signal_name: str = betterproto.string_field(12)
    signal_input: v1common.Payloads = betterproto.message_field(13)
    control: str = betterproto.string_field(14)
    # Default: WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE.
    retry_policy: v1common.RetryPolicy = betterproto.message_field(15)
    cron_schedule: str = betterproto.string_field(16)
    memo: v1common.Memo = betterproto.message_field(17)
    search_attributes: v1common.SearchAttributes = betterproto.message_field(18)
    header: v1common.Header = betterproto.message_field(19)


@dataclass
class SignalWithStartWorkflowExecutionResponse(betterproto.Message):
    run_id: str = betterproto.string_field(1)


@dataclass
class ResetWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    reason: str = betterproto.string_field(3)
    workflow_task_finish_event_id: int = betterproto.int64_field(4)
    request_id: str = betterproto.string_field(5)


@dataclass
class ResetWorkflowExecutionResponse(betterproto.Message):
    run_id: str = betterproto.string_field(1)


@dataclass
class TerminateWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    workflow_execution: v1common.WorkflowExecution = betterproto.message_field(2)
    reason: str = betterproto.string_field(3)
    details: v1common.Payloads = betterproto.message_field(4)
    identity: str = betterproto.string_field(5)


@dataclass
class TerminateWorkflowExecutionResponse(betterproto.Message):
    pass


@dataclass
class ListOpenWorkflowExecutionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    maximum_page_size: int = betterproto.int32_field(2)
    next_page_token: bytes = betterproto.bytes_field(3)
    start_time_filter: v1filter.StartTimeFilter = betterproto.message_field(4)
    execution_filter: v1filter.WorkflowExecutionFilter = betterproto.message_field(
        5, group="filters"
    )
    type_filter: v1filter.WorkflowTypeFilter = betterproto.message_field(
        6, group="filters"
    )


@dataclass
class ListOpenWorkflowExecutionsResponse(betterproto.Message):
    executions: List[v1workflow.WorkflowExecutionInfo] = betterproto.message_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class ListClosedWorkflowExecutionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    maximum_page_size: int = betterproto.int32_field(2)
    next_page_token: bytes = betterproto.bytes_field(3)
    start_time_filter: v1filter.StartTimeFilter = betterproto.message_field(4)
    execution_filter: v1filter.WorkflowExecutionFilter = betterproto.message_field(
        5, group="filters"
    )
    type_filter: v1filter.WorkflowTypeFilter = betterproto.message_field(
        6, group="filters"
    )
    status_filter: v1filter.StatusFilter = betterproto.message_field(7, group="filters")


@dataclass
class ListClosedWorkflowExecutionsResponse(betterproto.Message):
    executions: List[v1workflow.WorkflowExecutionInfo] = betterproto.message_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class ListWorkflowExecutionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    page_size: int = betterproto.int32_field(2)
    next_page_token: bytes = betterproto.bytes_field(3)
    query: str = betterproto.string_field(4)


@dataclass
class ListWorkflowExecutionsResponse(betterproto.Message):
    executions: List[v1workflow.WorkflowExecutionInfo] = betterproto.message_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class ListArchivedWorkflowExecutionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    page_size: int = betterproto.int32_field(2)
    next_page_token: bytes = betterproto.bytes_field(3)
    query: str = betterproto.string_field(4)


@dataclass
class ListArchivedWorkflowExecutionsResponse(betterproto.Message):
    executions: List[v1workflow.WorkflowExecutionInfo] = betterproto.message_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class ScanWorkflowExecutionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    page_size: int = betterproto.int32_field(2)
    next_page_token: bytes = betterproto.bytes_field(3)
    query: str = betterproto.string_field(4)


@dataclass
class ScanWorkflowExecutionsResponse(betterproto.Message):
    executions: List[v1workflow.WorkflowExecutionInfo] = betterproto.message_field(1)
    next_page_token: bytes = betterproto.bytes_field(2)


@dataclass
class CountWorkflowExecutionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    query: str = betterproto.string_field(2)


@dataclass
class CountWorkflowExecutionsResponse(betterproto.Message):
    count: int = betterproto.int64_field(1)


@dataclass
class GetSearchAttributesRequest(betterproto.Message):
    pass


@dataclass
class GetSearchAttributesResponse(betterproto.Message):
    keys: Dict[str, v1enums.IndexedValueType] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_ENUM
    )


@dataclass
class RespondQueryTaskCompletedRequest(betterproto.Message):
    """TODO:  deprecated APIs"""

    task_token: bytes = betterproto.bytes_field(1)
    completed_type: v1enums.QueryResultType = betterproto.enum_field(2)
    query_result: v1common.Payloads = betterproto.message_field(3)
    error_message: str = betterproto.string_field(4)
    worker_version_info: v1version.WorkerVersionInfo = betterproto.message_field(5)


@dataclass
class RespondQueryTaskCompletedResponse(betterproto.Message):
    pass


@dataclass
class ResetStickyTaskQueueRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    execution: v1common.WorkflowExecution = betterproto.message_field(2)


@dataclass
class ResetStickyTaskQueueResponse(betterproto.Message):
    pass


@dataclass
class QueryWorkflowRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    execution: v1common.WorkflowExecution = betterproto.message_field(2)
    query: v1query.WorkflowQuery = betterproto.message_field(3)
    # QueryRejectCondition can used to reject the query if workflow state does
    # not satisfy condition. Default: QUERY_REJECT_CONDITION_NONE.
    query_reject_condition: v1enums.QueryRejectCondition = betterproto.enum_field(4)


@dataclass
class QueryWorkflowResponse(betterproto.Message):
    query_result: v1common.Payloads = betterproto.message_field(1)
    query_rejected: v1query.QueryRejected = betterproto.message_field(2)


@dataclass
class DescribeWorkflowExecutionRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    execution: v1common.WorkflowExecution = betterproto.message_field(2)


@dataclass
class DescribeWorkflowExecutionResponse(betterproto.Message):
    execution_config: v1workflow.WorkflowExecutionConfig = betterproto.message_field(1)
    workflow_execution_info: v1workflow.WorkflowExecutionInfo = betterproto.message_field(
        2
    )
    pending_activities: List[
        v1workflow.PendingActivityInfo
    ] = betterproto.message_field(3)
    pending_children: List[
        v1workflow.PendingChildExecutionInfo
    ] = betterproto.message_field(4)


@dataclass
class DescribeTaskQueueRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(2)
    task_queue_type: v1enums.TaskQueueType = betterproto.enum_field(3)
    include_task_queue_status: bool = betterproto.bool_field(4)


@dataclass
class DescribeTaskQueueResponse(betterproto.Message):
    pollers: List[v1taskqueue.PollerInfo] = betterproto.message_field(1)
    task_queue_status: v1taskqueue.TaskQueueStatus = betterproto.message_field(2)


@dataclass
class GetClusterInfoRequest(betterproto.Message):
    pass


@dataclass
class GetClusterInfoResponse(betterproto.Message):
    """GetClusterInfoResponse contains information about Temporal cluster"""

    supported_sdk_versions: v1version.SupportedSDKVersions = betterproto.message_field(
        1
    )


@dataclass
class ListTaskQueuePartitionsRequest(betterproto.Message):
    namespace: str = betterproto.string_field(1)
    task_queue: v1taskqueue.TaskQueue = betterproto.message_field(2)


@dataclass
class ListTaskQueuePartitionsResponse(betterproto.Message):
    activity_task_queue_partitions: List[
        v1taskqueue.TaskQueuePartitionMetadata
    ] = betterproto.message_field(1)
    workflow_task_queue_partitions: List[
        v1taskqueue.TaskQueuePartitionMetadata
    ] = betterproto.message_field(2)


class WorkflowServiceStub(betterproto.ServiceStub):
    """
    WorkflowService API is exposed to provide support for long running
    applications.  Application is expected to call StartWorkflowExecution to
    create an instance for each instance of long running workflow.  Such
    applications are expected to have a worker which regularly polls for
    WorkflowTask and ActivityTask from the WorkflowService.  For each
    WorkflowTask, application is expected to process the history of events for
    that session and respond back with next commands.  For each ActivityTask,
    application is expected to execute the actual logic for that task and
    respond back with completion or failure.  Worker is expected to regularly
    heartbeat while activity task is running.
    """

    async def register_namespace(
        self, *, request: RegisterNamespaceRequest
    ) -> RegisterNamespaceResponse:
        """
        RegisterNamespace creates a new namespace which can be used as a
        container for all resources.  Namespace is a top level entity within
        Temporal, used as a container for all resources like workflow
        executions, task queues, etc.  Namespace acts as a sandbox and provides
        isolation for all resources within the namespace.  All resources
        belongs to exactly one namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RegisterNamespace",
            request,
            RegisterNamespaceResponse,
        )

    async def describe_namespace(
        self, *, request: DescribeNamespaceRequest
    ) -> DescribeNamespaceResponse:
        """
        DescribeNamespace returns the information and configuration for a
        registered namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeNamespace",
            request,
            DescribeNamespaceResponse,
        )

    async def list_namespaces(
        self, *, request: ListNamespacesRequest
    ) -> ListNamespacesResponse:
        """
        ListNamespaces returns the information and configuration for all
        namespaces.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListNamespaces",
            request,
            ListNamespacesResponse,
        )

    async def update_namespace(
        self, *, request: UpdateNamespaceRequest
    ) -> UpdateNamespaceResponse:
        """
        (-- api-linter: core::0134::method-signature=disabled     aip.dev/not-
        precedent: UpdateNamespace RPC doesn't follow Google API format. --)
        (-- api-linter: core::0134::response-message-name=disabled
        aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API
        format. --) UpdateNamespace is used to update the information and
        configuration for a registered namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/UpdateNamespace",
            request,
            UpdateNamespaceResponse,
        )

    async def deprecate_namespace(
        self, *, request: DeprecateNamespaceRequest
    ) -> DeprecateNamespaceResponse:
        """
        DeprecateNamespace is used to update state of a registered namespace to
        DEPRECATED.  Once the namespace is deprecated it cannot be used to
        start new workflow executions.  Existing workflow executions will
        continue to run on deprecated namespaces.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DeprecateNamespace",
            request,
            DeprecateNamespaceResponse,
        )

    async def start_workflow_execution(
        self, *, request: StartWorkflowExecutionRequest
    ) -> StartWorkflowExecutionResponse:
        """
        StartWorkflowExecution starts a new long running workflow instance.  It
        will create the instance with 'WorkflowExecutionStarted' event in
        history and also schedule the first WorkflowTask for the worker to make
        the first command for this instance.  It will return
        'WorkflowExecutionAlreadyStartedFailure', if an instance already exists
        with same workflowId.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/StartWorkflowExecution",
            request,
            StartWorkflowExecutionResponse,
        )

    async def get_workflow_execution_history(
        self, *, request: GetWorkflowExecutionHistoryRequest
    ) -> GetWorkflowExecutionHistoryResponse:
        """
        GetWorkflowExecutionHistory returns the history of specified workflow
        execution.  It fails with 'NotFoundFailure' if specified workflow
        execution in unknown to the service.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetWorkflowExecutionHistory",
            request,
            GetWorkflowExecutionHistoryResponse,
        )

    async def poll_workflow_task_queue(
        self, *, request: PollWorkflowTaskQueueRequest
    ) -> PollWorkflowTaskQueueResponse:
        """
        PollWorkflowTaskQueue is called by application worker to process
        WorkflowTask from a specific task queue.  A WorkflowTask is dispatched
        to callers for active workflow executions, with pending workflow tasks.
        Application is then expected to call 'RespondWorkflowTaskCompleted' API
        when it is done processing the WorkflowTask. It will also create a
        'WorkflowTaskStarted' event in the history for that session before
        handing off WorkflowTask to application worker.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/PollWorkflowTaskQueue",
            request,
            PollWorkflowTaskQueueResponse,
        )

    async def respond_workflow_task_completed(
        self, *, request: RespondWorkflowTaskCompletedRequest
    ) -> RespondWorkflowTaskCompletedResponse:
        """
        RespondWorkflowTaskCompleted is called by application worker to
        complete a WorkflowTask handed as a result of 'PollWorkflowTaskQueue'
        API call.  Completing a WorkflowTask will result in new events for the
        workflow execution and potentially new ActivityTask being created for
        corresponding commands.  It will also create a WorkflowTaskCompleted
        event in the history for that session.  Use the 'taskToken' provided as
        response of PollWorkflowTaskQueue API call for completing the
        WorkflowTask. The response could contain a new workflow task if there
        is one or if the request asking for one.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondWorkflowTaskCompleted",
            request,
            RespondWorkflowTaskCompletedResponse,
        )

    async def respond_workflow_task_failed(
        self, *, request: RespondWorkflowTaskFailedRequest
    ) -> RespondWorkflowTaskFailedResponse:
        """
        RespondWorkflowTaskFailed is called by application worker to indicate
        failure.  This results in WorkflowTaskFailedEvent written to the
        history and a new WorkflowTask created.  This API can be used by client
        to either clear sticky task queue or report any panics during
        WorkflowTask processing.  Temporal will only append first
        WorkflowTaskFailed event to the history of workflow execution for
        consecutive failures.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondWorkflowTaskFailed",
            request,
            RespondWorkflowTaskFailedResponse,
        )

    async def poll_activity_task_queue(
        self, *, request: PollActivityTaskQueueRequest
    ) -> PollActivityTaskQueueResponse:
        """
        PollActivityTaskQueue is called by application worker to process
        ActivityTask from a specific task queue.  ActivityTask is dispatched to
        callers whenever a ScheduleTask command is made for a workflow
        execution. Application is expected to call
        'RespondActivityTaskCompleted' or 'RespondActivityTaskFailed' once it
        is done processing the task. Application also needs to call
        'RecordActivityTaskHeartbeat' API within 'heartbeatTimeoutSeconds'
        interval to prevent the task from getting timed out.  An event
        'ActivityTaskStarted' event is also written to workflow execution
        history before the ActivityTask is dispatched to application worker.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/PollActivityTaskQueue",
            request,
            PollActivityTaskQueueResponse,
        )

    async def record_activity_task_heartbeat(
        self, *, request: RecordActivityTaskHeartbeatRequest
    ) -> RecordActivityTaskHeartbeatResponse:
        """
        RecordActivityTaskHeartbeat is called by application worker while it is
        processing an ActivityTask.  If worker fails to heartbeat within
        'heartbeatTimeoutSeconds' interval for the ActivityTask, then it will
        be marked as timedout and 'ActivityTaskTimedOut' event will be written
        to the workflow history.  Calling 'RecordActivityTaskHeartbeat' will
        fail with 'NotFoundFailure' in such situations.  Use the 'taskToken'
        provided as response of PollActivityTaskQueue API call for heart
        beating.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RecordActivityTaskHeartbeat",
            request,
            RecordActivityTaskHeartbeatResponse,
        )

    async def record_activity_task_heartbeat_by_id(
        self, *, request: RecordActivityTaskHeartbeatByIdRequest
    ) -> RecordActivityTaskHeartbeatByIdResponse:
        """
        (-- api-linter: core::0136::prepositions=disabled     aip.dev/not-
        precedent: "By" is used to indicate request type. --)
        RecordActivityTaskHeartbeatById is called by application worker while
        it is processing an ActivityTask.  If worker fails to heartbeat within
        'heartbeatTimeoutSeconds' interval for the ActivityTask, then it will
        be marked as timed out and 'ActivityTaskTimedOut' event will be written
        to the workflow history.  Calling 'RecordActivityTaskHeartbeatById'
        will fail with 'NotFoundFailure' in such situations.  Instead of using
        'taskToken' like in RecordActivityTaskHeartbeat, use Namespace,
        WorkflowId and ActivityId
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RecordActivityTaskHeartbeatById",
            request,
            RecordActivityTaskHeartbeatByIdResponse,
        )

    async def respond_activity_task_completed(
        self, *, request: RespondActivityTaskCompletedRequest
    ) -> RespondActivityTaskCompletedResponse:
        """
        RespondActivityTaskCompleted is called by application worker when it is
        done processing an ActivityTask.  It will result in a new
        'ActivityTaskCompleted' event being written to the workflow history and
        a new WorkflowTask created for the workflow so new commands could be
        made.  Use the 'taskToken' provided as response of
        PollActivityTaskQueue API call for completion. It fails with
        'NotFoundFailure' if the taskToken is not valid anymore due to activity
        timeout.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCompleted",
            request,
            RespondActivityTaskCompletedResponse,
        )

    async def respond_activity_task_completed_by_id(
        self, *, request: RespondActivityTaskCompletedByIdRequest
    ) -> RespondActivityTaskCompletedByIdResponse:
        """
        (-- api-linter: core::0136::prepositions=disabled     aip.dev/not-
        precedent: "By" is used to indicate request type. --)
        RespondActivityTaskCompletedById is called by application worker when
        it is done processing an ActivityTask. It will result in a new
        'ActivityTaskCompleted' event being written to the workflow history and
        a new WorkflowTask created for the workflow so new commands could be
        made.  Similar to RespondActivityTaskCompleted but use Namespace,
        WorkflowId and ActivityId instead of 'taskToken' for completion. It
        fails with 'NotFoundFailure' if the these Ids are not valid anymore due
        to activity timeout.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCompletedById",
            request,
            RespondActivityTaskCompletedByIdResponse,
        )

    async def respond_activity_task_failed(
        self, *, request: RespondActivityTaskFailedRequest
    ) -> RespondActivityTaskFailedResponse:
        """
        RespondActivityTaskFailed is called by application worker when it is
        done processing an ActivityTask.  It will result in a new
        'ActivityTaskFailed' event being written to the workflow history and a
        new WorkflowTask created for the workflow instance so new commands
        could be made.  Use the 'taskToken' provided as response of
        PollActivityTaskQueue API call for completion. It fails with
        'NotFoundFailure' if the taskToken is not valid anymore due to activity
        timeout.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskFailed",
            request,
            RespondActivityTaskFailedResponse,
        )

    async def respond_activity_task_failed_by_id(
        self, *, request: RespondActivityTaskFailedByIdRequest
    ) -> RespondActivityTaskFailedByIdResponse:
        """
        (-- api-linter: core::0136::prepositions=disabled     aip.dev/not-
        precedent: "By" is used to indicate request type. --)
        RespondActivityTaskFailedById is called by application worker when it
        is done processing an ActivityTask. It will result in a new
        'ActivityTaskFailed' event being written to the workflow history and a
        new WorkflowTask created for the workflow instance so new commands
        could be made.  Similar to RespondActivityTaskFailed but use Namespace,
        WorkflowId and ActivityId instead of 'taskToken' for completion. It
        fails with 'NotFoundFailure' if the these Ids are not valid anymore due
        to activity timeout.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskFailedById",
            request,
            RespondActivityTaskFailedByIdResponse,
        )

    async def respond_activity_task_canceled(
        self, *, request: RespondActivityTaskCanceledRequest
    ) -> RespondActivityTaskCanceledResponse:
        """
        RespondActivityTaskCanceled is called by application worker when it is
        successfully canceled an ActivityTask.  It will result in a new
        'ActivityTaskCanceled' event being written to the workflow history and
        a new WorkflowTask created for the workflow instance so new commands
        could be made.  Use the 'taskToken' provided as response of
        PollActivityTaskQueue API call for completion. It fails with
        'NotFoundFailure' if the taskToken is not valid anymore due to activity
        timeout.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCanceled",
            request,
            RespondActivityTaskCanceledResponse,
        )

    async def respond_activity_task_canceled_by_id(
        self, *, request: RespondActivityTaskCanceledByIdRequest
    ) -> RespondActivityTaskCanceledByIdResponse:
        """
        (-- api-linter: core::0136::prepositions=disabled     aip.dev/not-
        precedent: "By" is used to indicate request type. --)
        RespondActivityTaskCanceledById is called by application worker when it
        is successfully canceled an ActivityTask. It will result in a new
        'ActivityTaskCanceled' event being written to the workflow history and
        a new WorkflowTask created for the workflow instance so new commands
        could be made.  Similar to RespondActivityTaskCanceled but use
        Namespace, WorkflowId and ActivityId instead of 'taskToken' for
        completion. It fails with 'NotFoundFailure' if the these Ids are not
        valid anymore due to activity timeout.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCanceledById",
            request,
            RespondActivityTaskCanceledByIdResponse,
        )

    async def request_cancel_workflow_execution(
        self, *, request: RequestCancelWorkflowExecutionRequest
    ) -> RequestCancelWorkflowExecutionResponse:
        """
        RequestCancelWorkflowExecution is called by application worker when it
        wants to request cancellation of a workflow instance. It will result in
        a new 'WorkflowExecutionCancelRequested' event being written to the
        workflow history and a new WorkflowTask created for the workflow
        instance so new commands could be made. It fails with 'NotFoundFailure'
        if the workflow is not valid anymore due to completion or doesn't
        exist.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RequestCancelWorkflowExecution",
            request,
            RequestCancelWorkflowExecutionResponse,
        )

    async def signal_workflow_execution(
        self, *, request: SignalWorkflowExecutionRequest
    ) -> SignalWorkflowExecutionResponse:
        """
        SignalWorkflowExecution is used to send a signal event to running
        workflow execution.  This results in WorkflowExecutionSignaled event
        recorded in the history and a workflow task being created for the
        execution.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/SignalWorkflowExecution",
            request,
            SignalWorkflowExecutionResponse,
        )

    async def signal_with_start_workflow_execution(
        self, *, request: SignalWithStartWorkflowExecutionRequest
    ) -> SignalWithStartWorkflowExecutionResponse:
        """
        (-- api-linter: core::0136::prepositions=disabled     aip.dev/not-
        precedent: "With" is used to indicate combined operation. --)
        SignalWithStartWorkflowExecution is used to ensure sending signal to a
        workflow. If the workflow is running, this results in
        WorkflowExecutionSignaled event being recorded in the history and a
        workflow task being created for the execution. If the workflow is not
        running or not found, this results in WorkflowExecutionStarted and
        WorkflowExecutionSignaled events being recorded in history, and a
        workflow task being created for the execution
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/SignalWithStartWorkflowExecution",
            request,
            SignalWithStartWorkflowExecutionResponse,
        )

    async def reset_workflow_execution(
        self, *, request: ResetWorkflowExecutionRequest
    ) -> ResetWorkflowExecutionResponse:
        """
        ResetWorkflowExecution reset an existing workflow execution to
        WorkflowTaskCompleted event(exclusive). And it will immediately
        terminating the current execution instance.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ResetWorkflowExecution",
            request,
            ResetWorkflowExecutionResponse,
        )

    async def terminate_workflow_execution(
        self, *, request: TerminateWorkflowExecutionRequest
    ) -> TerminateWorkflowExecutionResponse:
        """
        TerminateWorkflowExecution terminates an existing workflow execution by
        recording WorkflowExecutionTerminated event in the history and
        immediately terminating the execution instance.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/TerminateWorkflowExecution",
            request,
            TerminateWorkflowExecutionResponse,
        )

    async def list_open_workflow_executions(
        self, *, request: ListOpenWorkflowExecutionsRequest
    ) -> ListOpenWorkflowExecutionsResponse:
        """
        ListOpenWorkflowExecutions is a visibility API to list the open
        executions in a specific namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListOpenWorkflowExecutions",
            request,
            ListOpenWorkflowExecutionsResponse,
        )

    async def list_closed_workflow_executions(
        self, *, request: ListClosedWorkflowExecutionsRequest
    ) -> ListClosedWorkflowExecutionsResponse:
        """
        ListClosedWorkflowExecutions is a visibility API to list the closed
        executions in a specific namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListClosedWorkflowExecutions",
            request,
            ListClosedWorkflowExecutionsResponse,
        )

    async def list_workflow_executions(
        self, *, request: ListWorkflowExecutionsRequest
    ) -> ListWorkflowExecutionsResponse:
        """
        ListWorkflowExecutions is a visibility API to list workflow executions
        in a specific namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListWorkflowExecutions",
            request,
            ListWorkflowExecutionsResponse,
        )

    async def list_archived_workflow_executions(
        self, *, request: ListArchivedWorkflowExecutionsRequest
    ) -> ListArchivedWorkflowExecutionsResponse:
        """
        ListArchivedWorkflowExecutions is a visibility API to list archived
        workflow executions in a specific namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListArchivedWorkflowExecutions",
            request,
            ListArchivedWorkflowExecutionsResponse,
        )

    async def scan_workflow_executions(
        self, *, request: ScanWorkflowExecutionsRequest
    ) -> ScanWorkflowExecutionsResponse:
        """
        ScanWorkflowExecutions is a visibility API to list large amount of
        workflow executions in a specific namespace without order.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ScanWorkflowExecutions",
            request,
            ScanWorkflowExecutionsResponse,
        )

    async def count_workflow_executions(
        self, *, request: CountWorkflowExecutionsRequest
    ) -> CountWorkflowExecutionsResponse:
        """
        CountWorkflowExecutions is a visibility API to count of workflow
        executions in a specific namespace.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/CountWorkflowExecutions",
            request,
            CountWorkflowExecutionsResponse,
        )

    async def get_search_attributes(
        self, *, request: GetSearchAttributesRequest
    ) -> GetSearchAttributesResponse:
        """
        GetSearchAttributes is a visibility API to get all legal keys that
        could be used in list APIs
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetSearchAttributes",
            request,
            GetSearchAttributesResponse,
        )

    async def respond_query_task_completed(
        self, *, request: RespondQueryTaskCompletedRequest
    ) -> RespondQueryTaskCompletedResponse:
        """
        RespondQueryTaskCompleted is called by application worker to complete a
        QueryTask (which is a WorkflowTask for query) as a result of
        'PollWorkflowTaskQueue' API call. Completing a QueryTask will unblock
        the client call to 'QueryWorkflow' API and return the query result to
        client as a response to 'QueryWorkflow' API call.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondQueryTaskCompleted",
            request,
            RespondQueryTaskCompletedResponse,
        )

    async def reset_sticky_task_queue(
        self, *, request: ResetStickyTaskQueueRequest
    ) -> ResetStickyTaskQueueResponse:
        """
        ResetStickyTaskQueue resets the sticky task queue related information
        in mutable state of a given workflow. Things cleared are: 1.
        StickyTaskQueue 2. StickyScheduleToStartTimeout 3. ClientLibraryVersion
        4. ClientFeatureVersion 5. ClientImpl
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ResetStickyTaskQueue",
            request,
            ResetStickyTaskQueueResponse,
        )

    async def query_workflow(
        self, *, request: QueryWorkflowRequest
    ) -> QueryWorkflowResponse:
        """
        QueryWorkflow returns query result for a specified workflow execution
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/QueryWorkflow",
            request,
            QueryWorkflowResponse,
        )

    async def describe_workflow_execution(
        self, *, request: DescribeWorkflowExecutionRequest
    ) -> DescribeWorkflowExecutionResponse:
        """
        DescribeWorkflowExecution returns information about the specified
        workflow execution.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeWorkflowExecution",
            request,
            DescribeWorkflowExecutionResponse,
        )

    async def describe_task_queue(
        self, *, request: DescribeTaskQueueRequest
    ) -> DescribeTaskQueueResponse:
        """
        DescribeTaskQueue returns information about the target task queue,
        right now this API returns the pollers which polled this task queue in
        last few minutes.
        """

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeTaskQueue",
            request,
            DescribeTaskQueueResponse,
        )

    async def get_cluster_info(
        self, *, request: GetClusterInfoRequest
    ) -> GetClusterInfoResponse:
        """GetClusterInfo returns information about temporal cluster"""

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetClusterInfo",
            request,
            GetClusterInfoResponse,
        )

    async def list_task_queue_partitions(
        self, *, request: ListTaskQueuePartitionsRequest
    ) -> ListTaskQueuePartitionsResponse:

        return await self._unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListTaskQueuePartitions",
            request,
            ListTaskQueuePartitionsResponse,
        )
